/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.test;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.io.IOUtils;

public class StructureHelper {
    public static String field_229590_a_ = "gameteststructures";

    public static Rotation func_240562_a_(int n) {
        switch (n) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + n);
    }

    public static AxisAlignedBB func_229594_a_(StructureBlockTileEntity structureBlockTileEntity) {
        BlockPos blockPos = structureBlockTileEntity.func_174877_v();
        \u2603 = blockPos.func_177971_a(structureBlockTileEntity.func_189717_g().func_177982_a(-1, -1, -1));
        \u2603 = Template.func_207669_a(\u2603, Mirror.NONE, structureBlockTileEntity.func_189726_i(), blockPos);
        return new AxisAlignedBB(blockPos, \u2603);
    }

    public static MutableBoundingBox func_240568_b_(StructureBlockTileEntity structureBlockTileEntity) {
        BlockPos blockPos = structureBlockTileEntity.func_174877_v();
        \u2603 = blockPos.func_177971_a(structureBlockTileEntity.func_189717_g().func_177982_a(-1, -1, -1));
        \u2603 = Template.func_207669_a(\u2603, Mirror.NONE, structureBlockTileEntity.func_189726_i(), blockPos);
        return new MutableBoundingBox(blockPos, \u2603);
    }

    public static void func_240564_a_(BlockPos blockPos, BlockPos blockPos2, Rotation rotation, ServerWorld serverWorld) {
        BlockPos blockPos3 = Template.func_207669_a(blockPos.func_177971_a(blockPos2), Mirror.NONE, rotation, blockPos);
        serverWorld.func_175656_a(blockPos3, Blocks.field_150483_bI.func_176223_P());
        CommandBlockTileEntity \u26032 = (CommandBlockTileEntity)serverWorld.func_175625_s(blockPos3);
        \u26032.func_145993_a().func_145752_a("test runthis");
        \u2603 = Template.func_207669_a(blockPos3.func_177982_a(0, 0, -1), Mirror.NONE, rotation, blockPos3);
        serverWorld.func_175656_a(\u2603, Blocks.field_150430_aB.func_176223_P().func_185907_a(rotation));
    }

    public static void func_229603_a_(String string, BlockPos blockPos, BlockPos blockPos2, Rotation rotation, ServerWorld serverWorld) {
        MutableBoundingBox mutableBoundingBox = StructureHelper.func_229598_a_(blockPos, blockPos2, rotation);
        StructureHelper.func_229595_a_(mutableBoundingBox, blockPos.func_177956_o(), serverWorld);
        serverWorld.func_175656_a(blockPos, Blocks.field_185779_df.func_176223_P());
        StructureBlockTileEntity \u26032 = (StructureBlockTileEntity)serverWorld.func_175625_s(blockPos);
        \u26032.func_184406_a(false);
        \u26032.func_210163_a(new ResourceLocation(string));
        \u26032.func_184409_c(blockPos2);
        \u26032.func_184405_a(StructureMode.SAVE);
        \u26032.func_189710_f(true);
    }

    public static StructureBlockTileEntity func_240565_a_(String string, BlockPos blockPos, Rotation rotation, int n, ServerWorld serverWorld, boolean bl) {
        BlockPos blockPos2 = StructureHelper.func_229605_a_(string, serverWorld).func_186259_a();
        MutableBoundingBox \u26032 = StructureHelper.func_229598_a_(blockPos, blockPos2, rotation);
        if (rotation == Rotation.NONE) {
            \u2603 = blockPos;
        } else if (rotation == Rotation.CLOCKWISE_90) {
            \u2603 = blockPos.func_177982_a(blockPos2.func_177952_p() - 1, 0, 0);
        } else if (rotation == Rotation.CLOCKWISE_180) {
            \u2603 = blockPos.func_177982_a(blockPos2.func_177958_n() - 1, 0, blockPos2.func_177952_p() - 1);
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            \u2603 = blockPos.func_177982_a(0, 0, blockPos2.func_177958_n() - 1);
        } else {
            throw new IllegalArgumentException("Invalid rotation: " + (Object)((Object)rotation));
        }
        StructureHelper.func_229608_b_(blockPos, serverWorld);
        StructureHelper.func_229595_a_(\u26032, blockPos.func_177956_o(), serverWorld);
        StructureBlockTileEntity \u26033 = StructureHelper.func_240566_a_(string, \u2603, rotation, serverWorld, bl);
        ((ServerTickList)serverWorld.func_205220_G_()).func_205366_a(\u26032, true, false);
        serverWorld.func_229854_a_(\u26032);
        return \u26033;
    }

    private static void func_229608_b_(BlockPos blockPos, ServerWorld serverWorld) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        for (int i = -1; i < 4; ++i) {
            for (\u2603 = -1; \u2603 < 4; ++\u2603) {
                \u2603 = chunkPos.field_77276_a + i;
                \u2603 = chunkPos.field_77275_b + \u2603;
                serverWorld.func_217458_b(\u2603, \u2603, true);
            }
        }
    }

    public static void func_229595_a_(MutableBoundingBox mutableBoundingBox, int n, ServerWorld serverWorld) {
        MutableBoundingBox mutableBoundingBox2 = new MutableBoundingBox(mutableBoundingBox.field_78897_a - 2, mutableBoundingBox.field_78895_b - 3, mutableBoundingBox.field_78896_c - 3, mutableBoundingBox.field_78893_d + 3, mutableBoundingBox.field_78894_e + 20, mutableBoundingBox.field_78892_f + 3);
        BlockPos.func_229383_a_(mutableBoundingBox2).forEach(blockPos -> StructureHelper.func_229591_a_(n, blockPos, serverWorld));
        ((ServerTickList)serverWorld.func_205220_G_()).func_205366_a(mutableBoundingBox2, true, false);
        serverWorld.func_229854_a_(mutableBoundingBox2);
        AxisAlignedBB \u26032 = new AxisAlignedBB(mutableBoundingBox2.field_78897_a, mutableBoundingBox2.field_78895_b, mutableBoundingBox2.field_78896_c, mutableBoundingBox2.field_78893_d, mutableBoundingBox2.field_78894_e, mutableBoundingBox2.field_78892_f);
        List<Entity> \u26033 = serverWorld.func_175647_a(Entity.class, \u26032, entity -> !(entity instanceof PlayerEntity));
        \u26033.forEach(Entity::func_70106_y);
    }

    public static MutableBoundingBox func_229598_a_(BlockPos blockPos, BlockPos blockPos2, Rotation rotation) {
        BlockPos blockPos3 = blockPos.func_177971_a(blockPos2).func_177982_a(-1, -1, -1);
        \u2603 = Template.func_207669_a(blockPos3, Mirror.NONE, rotation, blockPos);
        MutableBoundingBox \u26032 = MutableBoundingBox.func_175899_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), \u2603.func_177958_n(), \u2603.func_177956_o(), \u2603.func_177952_p());
        int \u26033 = Math.min(\u26032.field_78897_a, \u26032.field_78893_d);
        int \u26034 = Math.min(\u26032.field_78896_c, \u26032.field_78892_f);
        \u2603 = new BlockPos(blockPos.func_177958_n() - \u26033, 0, blockPos.func_177952_p() - \u26034);
        \u26032.func_236989_a_(\u2603);
        return \u26032;
    }

    public static Optional<BlockPos> func_229596_a_(BlockPos blockPos, int n, ServerWorld serverWorld) {
        return StructureHelper.func_229609_c_(blockPos, n, serverWorld).stream().filter(blockPos2 -> StructureHelper.func_229599_a_(blockPos2, blockPos, serverWorld)).findFirst();
    }

    @Nullable
    public static BlockPos func_229607_b_(BlockPos blockPos, int n, ServerWorld serverWorld) {
        Comparator<BlockPos> comparator = Comparator.comparingInt(blockPos2 -> blockPos2.func_218139_n(blockPos));
        Collection<BlockPos> \u26032 = StructureHelper.func_229609_c_(blockPos, n, serverWorld);
        Optional<BlockPos> \u26033 = \u26032.stream().min(comparator);
        return \u26033.orElse(null);
    }

    public static Collection<BlockPos> func_229609_c_(BlockPos blockPos, int n, ServerWorld serverWorld) {
        ArrayList arrayList = Lists.newArrayList();
        AxisAlignedBB \u26032 = new AxisAlignedBB(blockPos);
        \u26032 = \u26032.func_186662_g(n);
        for (int i = (int)\u26032.field_72340_a; i <= (int)\u26032.field_72336_d; ++i) {
            for (\u2603 = (int)\u26032.field_72338_b; \u2603 <= (int)\u26032.field_72337_e; ++\u2603) {
                for (\u2603 = (int)\u26032.field_72339_c; \u2603 <= (int)\u26032.field_72334_f; ++\u2603) {
                    BlockPos blockPos2 = new BlockPos(i, \u2603, \u2603);
                    BlockState \u26033 = serverWorld.func_180495_p(blockPos2);
                    if (!\u26033.func_203425_a(Blocks.field_185779_df)) continue;
                    arrayList.add(blockPos2);
                }
            }
        }
        return arrayList;
    }

    private static Template func_229605_a_(String string, ServerWorld serverWorld) {
        TemplateManager templateManager = serverWorld.func_184163_y();
        Template \u26032 = templateManager.func_200219_b(new ResourceLocation(string));
        if (\u26032 != null) {
            return \u26032;
        }
        String \u26033 = string + ".snbt";
        Path \u26034 = Paths.get(field_229590_a_, \u26033);
        CompoundNBT \u26035 = StructureHelper.func_229606_a_(\u26034);
        if (\u26035 == null) {
            throw new RuntimeException("Could not find structure file " + \u26034 + ", and the structure is not available in the world structures either.");
        }
        return templateManager.func_227458_a_(\u26035);
    }

    private static StructureBlockTileEntity func_240566_a_(String string, BlockPos blockPos, Rotation rotation, ServerWorld serverWorld, boolean bl) {
        serverWorld.func_175656_a(blockPos, Blocks.field_185779_df.func_176223_P());
        StructureBlockTileEntity structureBlockTileEntity = (StructureBlockTileEntity)serverWorld.func_175625_s(blockPos);
        structureBlockTileEntity.func_184405_a(StructureMode.LOAD);
        structureBlockTileEntity.func_184408_a(rotation);
        structureBlockTileEntity.func_184406_a(false);
        structureBlockTileEntity.func_210163_a(new ResourceLocation(string));
        structureBlockTileEntity.func_242688_a(serverWorld, bl);
        if (structureBlockTileEntity.func_189717_g() != BlockPos.field_177992_a) {
            return structureBlockTileEntity;
        }
        Template \u26032 = StructureHelper.func_229605_a_(string, serverWorld);
        structureBlockTileEntity.func_242689_a(serverWorld, bl, \u26032);
        if (structureBlockTileEntity.func_189717_g() == BlockPos.field_177992_a) {
            throw new RuntimeException("Failed to load structure " + string);
        }
        return structureBlockTileEntity;
    }

    @Nullable
    private static CompoundNBT func_229606_a_(Path path) {
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            String \u26032 = IOUtils.toString((Reader)bufferedReader);
            return JsonToNBT.func_180713_a(\u26032);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new RuntimeException("Error while trying to load structure " + path, commandSyntaxException);
        }
    }

    private static void func_229591_a_(int n, BlockPos blockPos2, ServerWorld serverWorld) {
        BlockPos blockPos2;
        Object \u26033;
        BlockState blockState = null;
        FlatGenerationSettings \u26032 = FlatGenerationSettings.func_242869_a(serverWorld.func_241828_r().func_243612_b(Registry.field_239720_u_));
        if (\u26032 instanceof FlatGenerationSettings) {
            \u26033 = \u26032.func_202233_q();
            if (blockPos2.func_177956_o() < n && blockPos2.func_177956_o() <= ((BlockState[])\u26033).length) {
                blockState = \u26033[blockPos2.func_177956_o() - 1];
            }
        } else if (blockPos2.func_177956_o() == n - 1) {
            blockState = serverWorld.func_226691_t_(blockPos2).func_242440_e().func_242502_e().func_204108_a();
        } else if (blockPos2.func_177956_o() < n - 1) {
            blockState = serverWorld.func_226691_t_(blockPos2).func_242440_e().func_242502_e().func_204109_b();
        }
        if (blockState == null) {
            blockState = Blocks.field_150350_a.func_176223_P();
        }
        \u26033 = new BlockStateInput(blockState, Collections.emptySet(), null);
        ((BlockStateInput)\u26033).func_197230_a(serverWorld, blockPos2, 2);
        serverWorld.func_230547_a_(blockPos2, blockState.func_177230_c());
    }

    private static boolean func_229599_a_(BlockPos blockPos, BlockPos blockPos2, ServerWorld serverWorld) {
        StructureBlockTileEntity structureBlockTileEntity = (StructureBlockTileEntity)serverWorld.func_175625_s(blockPos);
        AxisAlignedBB \u26032 = StructureHelper.func_229594_a_(structureBlockTileEntity).func_186662_g(1.0);
        return \u26032.func_72318_a(Vector3d.func_237489_a_(blockPos2));
    }
}

