/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.profiler.DataPoint;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfilerSection;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilledProfileResult
implements IProfileResult {
    private static final Logger field_219930_a = LogManager.getLogger();
    private static final IProfilerSection field_230090_b_ = new IProfilerSection(){

        @Override
        public long func_230037_a_() {
            return 0L;
        }

        @Override
        public long func_230038_b_() {
            return 0L;
        }

        @Override
        public Object2LongMap<String> func_230039_c_() {
            return Object2LongMaps.emptyMap();
        }
    };
    private static final Splitter field_230091_c_ = Splitter.on((char)'\u001e');
    private static final Comparator<Map.Entry<String, Section>> field_230092_d_ = Map.Entry.comparingByValue(Comparator.comparingLong(section -> Section.func_230110_a_(section))).reversed();
    private final Map<String, ? extends IProfilerSection> field_230093_e_;
    private final long field_219932_c;
    private final int field_219933_d;
    private final long field_219934_e;
    private final int field_219935_f;
    private final int field_223509_h;

    public FilledProfileResult(Map<String, ? extends IProfilerSection> map, long l, int n, long l2, int n2) {
        this.field_230093_e_ = map;
        this.field_219932_c = l;
        this.field_219933_d = n;
        this.field_219934_e = l2;
        this.field_219935_f = n2;
        this.field_223509_h = n2 - n;
    }

    private IProfilerSection func_230104_c_(String string) {
        IProfilerSection iProfilerSection = this.field_230093_e_.get(string);
        return iProfilerSection != null ? iProfilerSection : field_230090_b_;
    }

    @Override
    public List<DataPoint> func_219917_a(String string2) {
        \u2603 = string2;
        IProfilerSection iProfilerSection = this.func_230104_c_("root");
        long \u26032 = iProfilerSection.func_230037_a_();
        \u2603 = this.func_230104_c_(string2);
        long \u26033 = \u2603.func_230037_a_();
        long \u26034 = \u2603.func_230038_b_();
        ArrayList \u26035 = Lists.newArrayList();
        if (!string2.isEmpty()) {
            String string2 = string2 + '\u001e';
        }
        long l = 0L;
        for (String string3 : this.field_230093_e_.keySet()) {
            if (!FilledProfileResult.func_230097_a_(string2, string3)) continue;
            l += this.func_230104_c_(string3).func_230037_a_();
        }
        float \u26036 = l;
        if (l < \u26033) {
            l = \u26033;
        }
        if (\u26032 < l) {
            \u26032 = l;
        }
        for (String string4 : this.field_230093_e_.keySet()) {
            if (!FilledProfileResult.func_230097_a_(string2, string4)) continue;
            IProfilerSection iProfilerSection2 = this.func_230104_c_(string4);
            long \u26037 = iProfilerSection2.func_230037_a_();
            double \u26038 = (double)\u26037 * 100.0 / (double)l;
            double \u26039 = (double)\u26037 * 100.0 / (double)\u26032;
            String \u260310 = string4.substring(string2.length());
            \u26035.add(new DataPoint(\u260310, \u26038, \u26039, iProfilerSection2.func_230038_b_()));
        }
        if ((float)l > \u26036) {
            \u26035.add(new DataPoint("unspecified", (double)((float)l - \u26036) * 100.0 / (double)l, (double)((float)l - \u26036) * 100.0 / (double)\u26032, \u26034));
        }
        Collections.sort(\u26035);
        \u26035.add(0, new DataPoint(\u2603, 100.0, (double)l * 100.0 / (double)\u26032, \u26034));
        return \u26035;
    }

    private static boolean func_230097_a_(String string, String string2) {
        return string2.length() > string.length() && string2.startsWith(string) && string2.indexOf(30, string.length() + 1) < 0;
    }

    private Map<String, Section> func_230106_h_() {
        TreeMap treeMap = Maps.newTreeMap();
        this.field_230093_e_.forEach((string, iProfilerSection) -> {
            Object2LongMap<String> object2LongMap = iProfilerSection.func_230039_c_();
            if (!object2LongMap.isEmpty()) {
                List list = field_230091_c_.splitToList((CharSequence)string);
                object2LongMap.forEach((string2, l) -> treeMap.computeIfAbsent(string2, string -> new Section()).func_230112_a_(list.iterator(), (long)l));
            }
        });
        return treeMap;
    }

    @Override
    public long func_219918_a() {
        return this.field_219932_c;
    }

    @Override
    public int func_219922_b() {
        return this.field_219933_d;
    }

    @Override
    public long func_219923_c() {
        return this.field_219934_e;
    }

    @Override
    public int func_219921_d() {
        return this.field_219935_f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean func_219919_a(File file) {
        boolean bl;
        file.getParentFile().mkdirs();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            outputStreamWriter.write(this.func_219929_a(this.func_219924_f(), this.func_219925_g()));
            bl = true;
        }
        catch (Throwable \u26032) {
            boolean bl2;
            try {
                field_219930_a.error("Could not save profiler results to {}", (Object)file, (Object)\u26032);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)outputStreamWriter);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
        return bl;
    }

    protected String func_219929_a(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---- Minecraft Profiler Results ----\n");
        stringBuilder.append("// ");
        stringBuilder.append(FilledProfileResult.func_219927_h());
        stringBuilder.append("\n\n");
        stringBuilder.append("Version: ").append(SharedConstants.func_215069_a().getId()).append('\n');
        stringBuilder.append("Time span: ").append(l / 1000000L).append(" ms\n");
        stringBuilder.append("Tick span: ").append(n).append(" ticks\n");
        stringBuilder.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)n / ((float)l / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringBuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.func_219928_a(0, "root", stringBuilder);
        stringBuilder.append("--- END PROFILE DUMP ---\n\n");
        Map<String, Section> \u26032 = this.func_230106_h_();
        if (!\u26032.isEmpty()) {
            stringBuilder.append("--- BEGIN COUNTER DUMP ---\n\n");
            this.func_230102_a_(\u26032, stringBuilder, n);
            stringBuilder.append("--- END COUNTER DUMP ---\n\n");
        }
        return stringBuilder.toString();
    }

    private static StringBuilder func_230098_a_(StringBuilder stringBuilder, int n) {
        stringBuilder.append(String.format("[%02d] ", n));
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            stringBuilder.append("|   ");
        }
        return stringBuilder;
    }

    private void func_219928_a(int n, String string2, StringBuilder stringBuilder) {
        List<DataPoint> list = this.func_219917_a(string2);
        Object2LongMap<String> \u26032 = ((IProfilerSection)ObjectUtils.firstNonNull((Object[])new IProfilerSection[]{this.field_230093_e_.get(string2), field_230090_b_})).func_230039_c_();
        \u26032.forEach((string, l) -> FilledProfileResult.func_230098_a_(stringBuilder, n).append('#').append((String)string).append(' ').append(l).append('/').append(l / (long)this.field_223509_h).append('\n'));
        if (list.size() < 3) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            DataPoint dataPoint = list.get(i);
            FilledProfileResult.func_230098_a_(stringBuilder, n).append(dataPoint.field_219945_c).append('(').append(dataPoint.field_223511_c).append('/').append(String.format(Locale.ROOT, "%.0f", Float.valueOf((float)dataPoint.field_223511_c / (float)this.field_223509_h))).append(')').append(" - ").append(String.format(Locale.ROOT, "%.2f", dataPoint.field_219943_a)).append("%/").append(String.format(Locale.ROOT, "%.2f", dataPoint.field_219944_b)).append("%\n");
            if ("unspecified".equals(dataPoint.field_219945_c)) continue;
            try {
                this.func_219928_a(n + 1, string2 + '\u001e' + dataPoint.field_219945_c, stringBuilder);
                continue;
            }
            catch (Exception \u26033) {
                stringBuilder.append("[[ EXCEPTION ").append(\u26033).append(" ]]");
            }
        }
    }

    private void func_230095_a_(int n, String string, Section section, int n2, StringBuilder stringBuilder) {
        FilledProfileResult.func_230098_a_(stringBuilder, n).append(string).append(" total:").append(section.field_230107_a_).append('/').append(section.field_230108_b_).append(" average: ").append(section.field_230107_a_ / (long)n2).append('/').append(section.field_230108_b_ / (long)n2).append('\n');
        section.field_230109_c_.entrySet().stream().sorted(field_230092_d_).forEach(entry -> this.func_230095_a_(n + 1, (String)entry.getKey(), (Section)entry.getValue(), n2, stringBuilder));
    }

    private void func_230102_a_(Map<String, Section> map, StringBuilder stringBuilder, int n) {
        map.forEach((string, section) -> {
            stringBuilder.append("-- Counter: ").append((String)string).append(" --\n");
            this.func_230095_a_(0, "root", (Section)((Section)section).field_230109_c_.get("root"), n, stringBuilder);
            stringBuilder.append("\n\n");
        });
    }

    private static String func_219927_h() {
        String[] stringArray = new String[]{"Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return stringArray[(int)(Util.func_211178_c() % (long)stringArray.length)];
        }
        catch (Throwable \u26032) {
            return "Witty comment unavailable :(";
        }
    }

    @Override
    public int func_219925_g() {
        return this.field_223509_h;
    }

    static class Section {
        private long field_230107_a_;
        private long field_230108_b_;
        private final Map<String, Section> field_230109_c_ = Maps.newHashMap();

        private Section() {
        }

        public void func_230112_a_(Iterator<String> iterator, long l) {
            this.field_230108_b_ += l;
            if (!iterator.hasNext()) {
                this.field_230107_a_ += l;
            } else {
                this.field_230109_c_.computeIfAbsent(iterator.next(), string -> new Section()).func_230112_a_(iterator, l);
            }
        }
    }
}

