/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.rcon.ClientThread;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConThread;
import net.minecraft.server.dedicated.ServerProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainThread
extends RConThread {
    private static final Logger field_232652_d_ = LogManager.getLogger();
    private final ServerSocket field_72649_j;
    private final String field_72650_k;
    private final List<ClientThread> field_72648_l = Lists.newArrayList();
    private final IServer field_232653_j_;

    private MainThread(IServer iServer, ServerSocket serverSocket, String string) {
        super("RCON Listener");
        this.field_232653_j_ = iServer;
        this.field_72649_j = serverSocket;
        this.field_72650_k = string;
    }

    private void func_72645_g() {
        this.field_72648_l.removeIf(clientThread -> !clientThread.func_72613_c());
    }

    @Override
    public void run() {
        try {
            while (this.field_72619_a) {
                try {
                    Socket socket = this.field_72649_j.accept();
                    ClientThread \u26032 = new ClientThread(this.field_232653_j_, this.field_72650_k, socket);
                    \u26032.func_241832_a();
                    this.field_72648_l.add(\u26032);
                    this.func_72645_g();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.func_72645_g();
                }
                catch (IOException iOException) {
                    if (!this.field_72619_a) continue;
                    field_232652_d_.info("IO exception: ", (Throwable)iOException);
                }
            }
        }
        finally {
            this.func_232655_a_(this.field_72649_j);
        }
    }

    @Nullable
    public static MainThread func_242130_a(IServer iServer) {
        ServerProperties serverProperties = iServer.func_213221_d_();
        String \u26032 = iServer.func_71277_t();
        if (\u26032.isEmpty()) {
            \u26032 = "0.0.0.0";
        }
        if (0 >= (\u2603 = serverProperties.field_219031_y) || 65535 < \u2603) {
            field_232652_d_.warn("Invalid rcon port {} found in server.properties, rcon disabled!", (Object)\u2603);
            return null;
        }
        String \u26033 = serverProperties.field_219032_z;
        if (\u26033.isEmpty()) {
            field_232652_d_.warn("No rcon password set in server.properties, rcon disabled!");
            return null;
        }
        try {
            ServerSocket serverSocket = new ServerSocket(\u2603, 0, InetAddress.getByName(\u26032));
            serverSocket.setSoTimeout(500);
            MainThread \u26034 = new MainThread(iServer, serverSocket, \u26033);
            if (!\u26034.func_241832_a()) {
                return null;
            }
            field_232652_d_.info("RCON running on {}:{}", (Object)\u26032, (Object)\u2603);
            return \u26034;
        }
        catch (IOException iOException) {
            field_232652_d_.warn("Unable to initialise RCON on {}:{}", (Object)\u26032, (Object)\u2603, (Object)iOException);
            return null;
        }
    }

    @Override
    public void func_219591_b() {
        this.field_72619_a = false;
        this.func_232655_a_(this.field_72649_j);
        super.func_219591_b();
        for (ClientThread clientThread : this.field_72648_l) {
            if (!clientThread.func_72613_c()) continue;
            clientThread.func_219591_b();
        }
        this.field_72648_l.clear();
    }

    private void func_232655_a_(ServerSocket serverSocket) {
        field_232652_d_.debug("closeSocket: {}", (Object)serverSocket);
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            field_232652_d_.warn("Failed to close socket", (Throwable)iOException);
        }
    }
}

