/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BeeEntity
extends AnimalEntity
implements IAngerable,
IFlyingAnimal {
    private static final DataParameter<Byte> field_226374_bw_ = EntityDataManager.func_187226_a(BeeEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Integer> field_226375_bx_ = EntityDataManager.func_187226_a(BeeEntity.class, DataSerializers.field_187192_b);
    private static final RangedInteger field_234180_bw_ = TickRangeConverter.func_233037_a_(20, 39);
    private UUID field_226376_by_;
    private float field_226377_bz_;
    private float field_226361_bA_;
    private int field_226362_bB_;
    private int field_226363_bC_;
    private int field_226364_bD_;
    private int field_226365_bE_;
    private int field_226366_bF_ = 0;
    private int field_226367_bG_ = 0;
    @Nullable
    private BlockPos field_226368_bH_ = null;
    @Nullable
    private BlockPos field_226369_bI_ = null;
    private PollinateGoal field_226370_bJ_;
    private FindBeehiveGoal field_226371_bK_;
    private FindFlowerGoal field_226372_bL_;
    private int field_226373_bM_;

    public BeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
        this.field_70765_h = new FlyingMovementController(this, 20, true);
        this.field_70749_g = new BeeLookController(this);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_226374_bw_, (byte)0);
        this.field_70180_af.func_187214_a(field_226375_bx_, 0);
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        if (iWorldReader.func_180495_p(blockPos).func_196958_f()) {
            return 10.0f;
        }
        return 0.0f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new StingGoal(this, 1.4f, true));
        this.field_70714_bg.func_75776_a(1, new EnterBeehiveGoal());
        this.field_70714_bg.func_75776_a(2, new BreedGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199805_a(ItemTags.field_226159_I_), false));
        this.field_226370_bJ_ = new PollinateGoal();
        this.field_70714_bg.func_75776_a(4, this.field_226370_bJ_);
        this.field_70714_bg.func_75776_a(5, new FollowParentGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(5, new UpdateBeehiveGoal());
        this.field_226371_bK_ = new FindBeehiveGoal();
        this.field_70714_bg.func_75776_a(5, this.field_226371_bK_);
        this.field_226372_bL_ = new FindFlowerGoal();
        this.field_70714_bg.func_75776_a(6, this.field_226372_bL_);
        this.field_70714_bg.func_75776_a(7, new FindPollinationTargetGoal());
        this.field_70714_bg.func_75776_a(8, new WanderGoal());
        this.field_70714_bg.func_75776_a(9, new SwimGoal(this));
        this.field_70715_bh.func_75776_a(1, new AngerGoal(this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AttackPlayerGoal(this));
        this.field_70715_bh.func_75776_a(3, new ResetAngerGoal<BeeEntity>(this, true));
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.func_226409_eA_()) {
            compoundNBT.func_218657_a("HivePos", NBTUtil.func_186859_a(this.func_226410_eB_()));
        }
        if (this.func_226425_er_()) {
            compoundNBT.func_218657_a("FlowerPos", NBTUtil.func_186859_a(this.func_226424_eq_()));
        }
        compoundNBT.func_74757_a("HasNectar", this.func_226411_eD_());
        compoundNBT.func_74757_a("HasStung", this.func_226412_eE_());
        compoundNBT.func_74768_a("TicksSincePollination", this.field_226363_bC_);
        compoundNBT.func_74768_a("CannotEnterHiveTicks", this.field_226364_bD_);
        compoundNBT.func_74768_a("CropsGrownSincePollination", this.field_226365_bE_);
        this.func_233682_c_(compoundNBT);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        this.field_226369_bI_ = null;
        if (compoundNBT.func_74764_b("HivePos")) {
            this.field_226369_bI_ = NBTUtil.func_186861_c(compoundNBT.func_74775_l("HivePos"));
        }
        this.field_226368_bH_ = null;
        if (compoundNBT.func_74764_b("FlowerPos")) {
            this.field_226368_bH_ = NBTUtil.func_186861_c(compoundNBT.func_74775_l("FlowerPos"));
        }
        super.func_70037_a(compoundNBT);
        this.func_226447_r_(compoundNBT.func_74767_n("HasNectar"));
        this.func_226449_s_(compoundNBT.func_74767_n("HasStung"));
        this.field_226363_bC_ = compoundNBT.func_74762_e("TicksSincePollination");
        this.field_226364_bD_ = compoundNBT.func_74762_e("CannotEnterHiveTicks");
        this.field_226365_bE_ = compoundNBT.func_74762_e("CropsGrownSincePollination");
        this.func_241358_a_((ServerWorld)this.field_70170_p, compoundNBT);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean bl = entity.func_70097_a(DamageSource.func_226252_a_(this), (int)this.func_233637_b_(Attributes.field_233823_f_));
        if (bl) {
            this.func_174815_a(this, entity);
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).func_226300_q_(((LivingEntity)entity).func_226297_df_() + 1);
                int n = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    n = 10;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    n = 18;
                }
                if (n > 0) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, n * 20, 0));
                }
            }
            this.func_226449_s_(true);
            this.func_241356_K__();
            this.func_184185_a(SoundEvents.field_226128_ac_, 1.0f, 1.0f);
        }
        return bl;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_226411_eD_() && this.func_226419_eM_() < 10 && this.field_70146_Z.nextFloat() < 0.05f) {
            for (int i = 0; i < this.field_70146_Z.nextInt(2) + 1; ++i) {
                this.func_226397_a_(this.field_70170_p, this.func_226277_ct_() - (double)0.3f, this.func_226277_ct_() + (double)0.3f, this.func_226281_cx_() - (double)0.3f, this.func_226281_cx_() + (double)0.3f, this.func_226283_e_(0.5), ParticleTypes.field_229430_aj_);
            }
        }
        this.func_226416_eJ_();
    }

    private void func_226397_a_(World world, double d, double d2, double d3, double d4, double d5, IParticleData iParticleData) {
        world.func_195594_a(iParticleData, MathHelper.func_219803_d(world.field_73012_v.nextDouble(), d, d2), d5, MathHelper.func_219803_d(world.field_73012_v.nextDouble(), d3, d4), 0.0, 0.0, 0.0);
    }

    private void func_226433_h_(BlockPos blockPos) {
        Vector3d vector3d = Vector3d.func_237492_c_(blockPos);
        int \u26032 = 0;
        BlockPos \u26033 = this.func_233580_cy_();
        int \u26034 = (int)vector3d.field_72448_b - \u26033.func_177956_o();
        if (\u26034 > 2) {
            \u26032 = 4;
        } else if (\u26034 < -2) {
            \u26032 = -4;
        }
        int \u26035 = 6;
        int \u26036 = 8;
        int \u26037 = \u26033.func_218139_n(blockPos);
        if (\u26037 < 15) {
            \u26035 = \u26037 / 2;
            \u26036 = \u26037 / 2;
        }
        if ((\u2603 = RandomPositionGenerator.func_226344_b_(this, \u26035, \u26036, \u26032, vector3d, 0.3141592741012573)) == null) {
            return;
        }
        this.field_70699_by.func_226335_a_(0.5f);
        this.field_70699_by.func_75492_a(\u2603.field_72450_a, \u2603.field_72448_b, \u2603.field_72449_c, 1.0);
    }

    @Nullable
    public BlockPos func_226424_eq_() {
        return this.field_226368_bH_;
    }

    public boolean func_226425_er_() {
        return this.field_226368_bH_ != null;
    }

    public void func_226431_g_(BlockPos blockPos) {
        this.field_226368_bH_ = blockPos;
    }

    private boolean func_226414_eH_() {
        return this.field_226363_bC_ > 3600;
    }

    private boolean func_226415_eI_() {
        if (this.field_226364_bD_ > 0 || this.field_226370_bJ_.func_226503_k_() || this.func_226412_eE_() || this.func_70638_az() != null) {
            return false;
        }
        boolean bl = this.func_226414_eH_() || this.field_70170_p.func_72896_J() || this.field_70170_p.func_226690_K_() || this.func_226411_eD_();
        return bl && !this.func_226417_eK_();
    }

    public void func_226450_t_(int n) {
        this.field_226364_bD_ = n;
    }

    public float func_226455_v_(float f) {
        return MathHelper.func_219799_g(f, this.field_226361_bA_, this.field_226377_bz_);
    }

    private void func_226416_eJ_() {
        this.field_226361_bA_ = this.field_226377_bz_;
        this.field_226377_bz_ = this.func_226423_eQ_() ? Math.min(1.0f, this.field_226377_bz_ + 0.2f) : Math.max(0.0f, this.field_226377_bz_ - 0.24f);
    }

    @Override
    protected void func_70619_bc() {
        boolean bl = this.func_226412_eE_();
        this.field_226373_bM_ = this.func_203005_aq() ? ++this.field_226373_bM_ : 0;
        if (this.field_226373_bM_ > 20) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (bl) {
            ++this.field_226362_bB_;
            if (this.field_226362_bB_ % 5 == 0 && this.field_70146_Z.nextInt(MathHelper.func_76125_a(1200 - this.field_226362_bB_, 1, 1200)) == 0) {
                this.func_70097_a(DamageSource.field_76377_j, this.func_110143_aJ());
            }
        }
        if (!this.func_226411_eD_()) {
            ++this.field_226363_bC_;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, false);
        }
    }

    public void func_226426_eu_() {
        this.field_226363_bC_ = 0;
    }

    private boolean func_226417_eK_() {
        if (this.field_226369_bI_ == null) {
            return false;
        }
        TileEntity tileEntity = this.field_70170_p.func_175625_s(this.field_226369_bI_);
        return tileEntity instanceof BeehiveTileEntity && ((BeehiveTileEntity)tileEntity).func_226968_d_();
    }

    @Override
    public int func_230256_F__() {
        return this.field_70180_af.func_187225_a(field_226375_bx_);
    }

    @Override
    public void func_230260_a__(int n) {
        this.field_70180_af.func_187227_b(field_226375_bx_, n);
    }

    @Override
    public UUID func_230257_G__() {
        return this.field_226376_by_;
    }

    @Override
    public void func_230259_a_(@Nullable UUID uUID) {
        this.field_226376_by_ = uUID;
    }

    @Override
    public void func_230258_H__() {
        this.func_230260_a__(field_234180_bw_.func_233018_a_(this.field_70146_Z));
    }

    private boolean func_226435_i_(BlockPos blockPos) {
        TileEntity tileEntity = this.field_70170_p.func_175625_s(blockPos);
        if (tileEntity instanceof BeehiveTileEntity) {
            return !((BeehiveTileEntity)tileEntity).func_226970_h_();
        }
        return false;
    }

    public boolean func_226409_eA_() {
        return this.field_226369_bI_ != null;
    }

    @Nullable
    public BlockPos func_226410_eB_() {
        return this.field_226369_bI_;
    }

    @Override
    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_229749_a_(this);
    }

    private int func_226419_eM_() {
        return this.field_226365_bE_;
    }

    private void func_226420_eN_() {
        this.field_226365_bE_ = 0;
    }

    private void func_226421_eO_() {
        ++this.field_226365_bE_;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_226364_bD_ > 0) {
                --this.field_226364_bD_;
            }
            if (this.field_226366_bF_ > 0) {
                --this.field_226366_bF_;
            }
            if (this.field_226367_bG_ > 0) {
                --this.field_226367_bG_;
            }
            boolean bl = this.func_233678_J__() && !this.func_226412_eE_() && this.func_70638_az() != null && this.func_70638_az().func_70068_e(this) < 4.0;
            this.func_226452_t_(bl);
            if (this.field_70173_aa % 20 == 0 && !this.func_226422_eP_()) {
                this.field_226369_bI_ = null;
            }
        }
    }

    private boolean func_226422_eP_() {
        if (!this.func_226409_eA_()) {
            return false;
        }
        TileEntity tileEntity = this.field_70170_p.func_175625_s(this.field_226369_bI_);
        return tileEntity != null && tileEntity.func_200662_C() == TileEntityType.field_226985_G_;
    }

    public boolean func_226411_eD_() {
        return this.func_226456_v_(8);
    }

    private void func_226447_r_(boolean bl) {
        if (bl) {
            this.func_226426_eu_();
        }
        this.func_226404_d_(8, bl);
    }

    public boolean func_226412_eE_() {
        return this.func_226456_v_(4);
    }

    private void func_226449_s_(boolean bl) {
        this.func_226404_d_(4, bl);
    }

    private boolean func_226423_eQ_() {
        return this.func_226456_v_(2);
    }

    private void func_226452_t_(boolean bl) {
        this.func_226404_d_(2, bl);
    }

    private boolean func_226437_j_(BlockPos blockPos) {
        return !this.func_226401_b_(blockPos, 32);
    }

    private void func_226404_d_(int n, boolean bl) {
        if (bl) {
            this.field_70180_af.func_187227_b(field_226374_bw_, (byte)(this.field_70180_af.func_187225_a(field_226374_bw_) | n));
        } else {
            this.field_70180_af.func_187227_b(field_226374_bw_, (byte)(this.field_70180_af.func_187225_a(field_226374_bw_) & ~n));
        }
    }

    private boolean func_226456_v_(int n) {
        return (this.field_70180_af.func_187225_a(field_226374_bw_) & n) != 0;
    }

    public static AttributeModifierMap.MutableAttribute func_234182_eX_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233822_e_, 0.6f).func_233815_a_(Attributes.field_233821_d_, 0.3f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    @Override
    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator flyingPathNavigator = new FlyingPathNavigator(this, world){

            @Override
            public boolean func_188555_b(BlockPos blockPos) {
                return !this.field_75513_b.func_180495_p(blockPos.func_177977_b()).func_196958_f();
            }

            @Override
            public void func_75501_e() {
                if (BeeEntity.this.field_226370_bJ_.func_226503_k_()) {
                    return;
                }
                super.func_75501_e();
            }
        };
        flyingPathNavigator.func_192879_a(false);
        flyingPathNavigator.func_212239_d(false);
        flyingPathNavigator.func_192878_b(true);
        return flyingPathNavigator;
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack.func_77973_b().func_206844_a(ItemTags.field_226159_I_);
    }

    private boolean func_226439_k_(BlockPos blockPos) {
        return this.field_70170_p.func_195588_v(blockPos) && this.field_70170_p.func_180495_p(blockPos).func_177230_c().func_203417_a(BlockTags.field_226149_I_);
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_226125_Z_;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_226124_Y_;
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    public BeeEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return EntityType.field_226289_e_.func_200721_a(serverWorld);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        if (this.func_70631_g_()) {
            return entitySize.field_220316_b * 0.5f;
        }
        return entitySize.field_220316_b * 0.5f;
    }

    @Override
    public boolean func_225503_b_(float f, float f2) {
        return false;
    }

    @Override
    protected void func_184231_a(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    @Override
    protected boolean func_191957_ae() {
        return true;
    }

    public void func_226413_eG_() {
        this.func_226447_r_(false);
        this.func_226420_eN_();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (!this.field_70170_p.field_72995_K) {
            this.field_226370_bJ_.func_226504_l_();
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    @Override
    protected void func_180466_bG(ITag<Fluid> iTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
    }

    @Override
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.5f * this.func_70047_e(), this.func_213311_cf() * 0.2f);
    }

    private boolean func_226401_b_(BlockPos blockPos, int n) {
        return blockPos.func_218141_a(this.func_233580_cy_(), n);
    }

    @Override
    public /* synthetic */ AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return this.func_241840_a(serverWorld, ageableEntity);
    }

    class EnterBeehiveGoal
    extends PassiveGoal {
        private EnterBeehiveGoal() {
        }

        @Override
        public boolean func_225506_g_() {
            TileEntity tileEntity;
            if (BeeEntity.this.func_226409_eA_() && BeeEntity.this.func_226415_eI_() && BeeEntity.this.field_226369_bI_.func_218137_a(BeeEntity.this.func_213303_ch(), 2.0) && (tileEntity = BeeEntity.this.field_70170_p.func_175625_s(BeeEntity.this.field_226369_bI_)) instanceof BeehiveTileEntity) {
                BeehiveTileEntity beehiveTileEntity = (BeehiveTileEntity)tileEntity;
                if (beehiveTileEntity.func_226970_h_()) {
                    BeeEntity.this.field_226369_bI_ = null;
                } else {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean func_225507_h_() {
            return false;
        }

        @Override
        public void func_75249_e() {
            TileEntity tileEntity = BeeEntity.this.field_70170_p.func_175625_s(BeeEntity.this.field_226369_bI_);
            if (tileEntity instanceof BeehiveTileEntity) {
                BeehiveTileEntity beehiveTileEntity = (BeehiveTileEntity)tileEntity;
                beehiveTileEntity.func_226961_a_(BeeEntity.this, BeeEntity.this.func_226411_eD_());
            }
        }
    }

    class StingGoal
    extends MeleeAttackGoal {
        StingGoal(CreatureEntity creatureEntity, double d, boolean bl) {
            super(creatureEntity, d, bl);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && BeeEntity.this.func_233678_J__() && !BeeEntity.this.func_226412_eE_();
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && BeeEntity.this.func_233678_J__() && !BeeEntity.this.func_226412_eE_();
        }
    }

    class FindPollinationTargetGoal
    extends PassiveGoal {
        private FindPollinationTargetGoal() {
        }

        @Override
        public boolean func_225506_g_() {
            if (BeeEntity.this.func_226419_eM_() >= 10) {
                return false;
            }
            if (BeeEntity.this.field_70146_Z.nextFloat() < 0.3f) {
                return false;
            }
            return BeeEntity.this.func_226411_eD_() && BeeEntity.this.func_226422_eP_();
        }

        @Override
        public boolean func_225507_h_() {
            return this.func_225506_g_();
        }

        @Override
        public void func_75246_d() {
            if (BeeEntity.this.field_70146_Z.nextInt(30) != 0) {
                return;
            }
            for (int i = 1; i <= 2; ++i) {
                int n;
                BlockPos blockPos = BeeEntity.this.func_233580_cy_().func_177979_c(i);
                BlockState \u26032 = BeeEntity.this.field_70170_p.func_180495_p(blockPos);
                Block \u26033 = \u26032.func_177230_c();
                boolean \u26034 = false;
                IntegerProperty \u26035 = null;
                if (!\u26033.func_203417_a(BlockTags.field_226153_ac_)) continue;
                if (\u26033 instanceof CropsBlock) {
                    CropsBlock cropsBlock = (CropsBlock)\u26033;
                    if (!cropsBlock.func_185525_y(\u26032)) {
                        \u26034 = true;
                        \u26035 = cropsBlock.func_185524_e();
                    }
                } else if (\u26033 instanceof StemBlock) {
                    int n2 = \u26032.func_177229_b(StemBlock.field_176484_a);
                    if (n2 < 7) {
                        \u26034 = true;
                        \u26035 = StemBlock.field_176484_a;
                    }
                } else if (\u26033 == Blocks.field_222434_lW && (n = \u26032.func_177229_b(SweetBerryBushBlock.field_220125_a).intValue()) < 3) {
                    \u26034 = true;
                    \u26035 = SweetBerryBushBlock.field_220125_a;
                }
                if (!\u26034) continue;
                BeeEntity.this.field_70170_p.func_217379_c(2005, blockPos, 0);
                BeeEntity.this.field_70170_p.func_175656_a(blockPos, (BlockState)\u26032.func_206870_a(\u26035, \u26032.func_177229_b(\u26035) + 1));
                BeeEntity.this.func_226421_eO_();
            }
        }
    }

    class UpdateBeehiveGoal
    extends PassiveGoal {
        private UpdateBeehiveGoal() {
        }

        @Override
        public boolean func_225506_g_() {
            return BeeEntity.this.field_226366_bF_ == 0 && !BeeEntity.this.func_226409_eA_() && BeeEntity.this.func_226415_eI_();
        }

        @Override
        public boolean func_225507_h_() {
            return false;
        }

        @Override
        public void func_75249_e() {
            BeeEntity.this.field_226366_bF_ = 200;
            List<BlockPos> list = this.func_226489_j_();
            if (list.isEmpty()) {
                return;
            }
            for (BlockPos blockPos : list) {
                if (BeeEntity.this.field_226371_bK_.func_226473_b_(blockPos)) continue;
                BeeEntity.this.field_226369_bI_ = blockPos;
                return;
            }
            BeeEntity.this.field_226371_bK_.func_226477_j_();
            BeeEntity.this.field_226369_bI_ = list.get(0);
        }

        private List<BlockPos> func_226489_j_() {
            BlockPos blockPos3 = BeeEntity.this.func_233580_cy_();
            PointOfInterestManager \u26032 = ((ServerWorld)BeeEntity.this.field_70170_p).func_217443_B();
            Stream<PointOfInterest> \u26033 = \u26032.func_219146_b(pointOfInterestType -> pointOfInterestType == PointOfInterestType.field_226356_s_ || pointOfInterestType == PointOfInterestType.field_226357_t_, blockPos3, 20, PointOfInterestManager.Status.ANY);
            return \u26033.map(PointOfInterest::func_218261_f).filter(blockPos -> BeeEntity.this.func_226435_i_(blockPos)).sorted(Comparator.comparingDouble(blockPos2 -> blockPos2.func_177951_i(blockPos3))).collect(Collectors.toList());
        }
    }

    class PollinateGoal
    extends PassiveGoal {
        private final Predicate<BlockState> field_226492_c_;
        private int field_226493_d_;
        private int field_226494_e_;
        private boolean field_226495_f_;
        private Vector3d field_226496_g_;
        private int field_226497_h_;

        PollinateGoal() {
            this.field_226492_c_ = blockState -> {
                if (blockState.func_235714_a_(BlockTags.field_226148_H_)) {
                    if (blockState.func_203425_a(Blocks.field_196800_gd)) {
                        return blockState.func_177229_b(DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER;
                    }
                    return true;
                }
                return blockState.func_235714_a_(BlockTags.field_219746_E);
            };
            this.field_226493_d_ = 0;
            this.field_226494_e_ = 0;
            this.field_226497_h_ = 0;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_225506_g_() {
            if (BeeEntity.this.field_226367_bG_ > 0) {
                return false;
            }
            if (BeeEntity.this.func_226411_eD_()) {
                return false;
            }
            if (BeeEntity.this.field_70170_p.func_72896_J()) {
                return false;
            }
            if (BeeEntity.this.field_70146_Z.nextFloat() < 0.7f) {
                return false;
            }
            Optional<BlockPos> optional = this.func_226507_o_();
            if (optional.isPresent()) {
                BeeEntity.this.field_226368_bH_ = optional.get();
                BeeEntity.this.field_70699_by.func_75492_a((double)BeeEntity.this.field_226368_bH_.func_177958_n() + 0.5, (double)BeeEntity.this.field_226368_bH_.func_177956_o() + 0.5, (double)BeeEntity.this.field_226368_bH_.func_177952_p() + 0.5, 1.2f);
                return true;
            }
            return false;
        }

        @Override
        public boolean func_225507_h_() {
            if (!this.field_226495_f_) {
                return false;
            }
            if (!BeeEntity.this.func_226425_er_()) {
                return false;
            }
            if (BeeEntity.this.field_70170_p.func_72896_J()) {
                return false;
            }
            if (this.func_226502_j_()) {
                return BeeEntity.this.field_70146_Z.nextFloat() < 0.2f;
            }
            if (BeeEntity.this.field_70173_aa % 20 == 0 && !BeeEntity.this.func_226439_k_(BeeEntity.this.field_226368_bH_)) {
                BeeEntity.this.field_226368_bH_ = null;
                return false;
            }
            return true;
        }

        private boolean func_226502_j_() {
            return this.field_226493_d_ > 400;
        }

        private boolean func_226503_k_() {
            return this.field_226495_f_;
        }

        private void func_226504_l_() {
            this.field_226495_f_ = false;
        }

        @Override
        public void func_75249_e() {
            this.field_226493_d_ = 0;
            this.field_226497_h_ = 0;
            this.field_226494_e_ = 0;
            this.field_226495_f_ = true;
            BeeEntity.this.func_226426_eu_();
        }

        @Override
        public void func_75251_c() {
            if (this.func_226502_j_()) {
                BeeEntity.this.func_226447_r_(true);
            }
            this.field_226495_f_ = false;
            BeeEntity.this.field_70699_by.func_75499_g();
            BeeEntity.this.field_226367_bG_ = 200;
        }

        @Override
        public void func_75246_d() {
            ++this.field_226497_h_;
            if (this.field_226497_h_ > 600) {
                BeeEntity.this.field_226368_bH_ = null;
                return;
            }
            Vector3d vector3d = Vector3d.func_237492_c_(BeeEntity.this.field_226368_bH_).func_72441_c(0.0, 0.6f, 0.0);
            if (vector3d.func_72438_d(BeeEntity.this.func_213303_ch()) > 1.0) {
                this.field_226496_g_ = vector3d;
                this.func_226505_m_();
                return;
            }
            if (this.field_226496_g_ == null) {
                this.field_226496_g_ = vector3d;
            }
            boolean \u26032 = BeeEntity.this.func_213303_ch().func_72438_d(this.field_226496_g_) <= 0.1;
            boolean \u26033 = true;
            if (!\u26032 && this.field_226497_h_ > 600) {
                BeeEntity.this.field_226368_bH_ = null;
                return;
            }
            if (\u26032) {
                boolean bl = \u2603 = BeeEntity.this.field_70146_Z.nextInt(25) == 0;
                if (\u2603) {
                    this.field_226496_g_ = new Vector3d(vector3d.func_82615_a() + (double)this.func_226506_n_(), vector3d.func_82617_b(), vector3d.func_82616_c() + (double)this.func_226506_n_());
                    BeeEntity.this.field_70699_by.func_75499_g();
                } else {
                    \u26033 = false;
                }
                BeeEntity.this.func_70671_ap().func_220679_a(vector3d.func_82615_a(), vector3d.func_82617_b(), vector3d.func_82616_c());
            }
            if (\u26033) {
                this.func_226505_m_();
            }
            ++this.field_226493_d_;
            if (BeeEntity.this.field_70146_Z.nextFloat() < 0.05f && this.field_226493_d_ > this.field_226494_e_ + 60) {
                this.field_226494_e_ = this.field_226493_d_;
                BeeEntity.this.func_184185_a(SoundEvents.field_226129_ad_, 1.0f, 1.0f);
            }
        }

        private void func_226505_m_() {
            BeeEntity.this.func_70605_aq().func_75642_a(this.field_226496_g_.func_82615_a(), this.field_226496_g_.func_82617_b(), this.field_226496_g_.func_82616_c(), 0.35f);
        }

        private float func_226506_n_() {
            return (BeeEntity.this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPos> func_226507_o_() {
            return this.func_226500_a_(this.field_226492_c_, 5.0);
        }

        private Optional<BlockPos> func_226500_a_(Predicate<BlockState> predicate, double d) {
            BlockPos blockPos = BeeEntity.this.func_233580_cy_();
            BlockPos.Mutable \u26032 = new BlockPos.Mutable();
            int \u26033 = 0;
            while ((double)\u26033 <= d) {
                int n = 0;
                while ((double)n < d) {
                    \u2603 = 0;
                    while (\u2603 <= n) {
                        int n2 = \u2603 = \u2603 < n && \u2603 > -n ? n : 0;
                        while (\u2603 <= n) {
                            \u26032.func_239621_a_(blockPos, \u2603, \u26033 - 1, \u2603);
                            if (blockPos.func_218141_a(\u26032, d) && predicate.test(BeeEntity.this.field_70170_p.func_180495_p(\u26032))) {
                                return Optional.of(\u26032);
                            }
                            \u2603 = \u2603 > 0 ? -\u2603 : 1 - \u2603;
                        }
                        \u2603 = \u2603 > 0 ? -\u2603 : 1 - \u2603;
                    }
                    ++n;
                }
                \u26033 = \u26033 > 0 ? -\u26033 : 1 - \u26033;
            }
            return Optional.empty();
        }
    }

    class BeeLookController
    extends LookController {
        BeeLookController(MobEntity mobEntity) {
            super(mobEntity);
        }

        @Override
        public void func_75649_a() {
            if (BeeEntity.this.func_233678_J__()) {
                return;
            }
            super.func_75649_a();
        }

        @Override
        protected boolean func_220680_b() {
            return !BeeEntity.this.field_226370_bJ_.func_226503_k_();
        }
    }

    public class FindFlowerGoal
    extends PassiveGoal {
        private int field_226481_c_;

        FindFlowerGoal() {
            this.field_226481_c_ = BeeEntity.this.field_70170_p.field_73012_v.nextInt(10);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_225506_g_() {
            return BeeEntity.this.field_226368_bH_ != null && !BeeEntity.this.func_213394_dL() && this.func_226482_j_() && BeeEntity.this.func_226439_k_(BeeEntity.this.field_226368_bH_) && !BeeEntity.this.func_226401_b_(BeeEntity.this.field_226368_bH_, 2);
        }

        @Override
        public boolean func_225507_h_() {
            return this.func_225506_g_();
        }

        @Override
        public void func_75249_e() {
            this.field_226481_c_ = 0;
            super.func_75249_e();
        }

        @Override
        public void func_75251_c() {
            this.field_226481_c_ = 0;
            BeeEntity.this.field_70699_by.func_75499_g();
            BeeEntity.this.field_70699_by.func_226336_g_();
        }

        @Override
        public void func_75246_d() {
            if (BeeEntity.this.field_226368_bH_ == null) {
                return;
            }
            ++this.field_226481_c_;
            if (this.field_226481_c_ > 600) {
                BeeEntity.this.field_226368_bH_ = null;
                return;
            }
            if (BeeEntity.this.field_70699_by.func_226337_n_()) {
                return;
            }
            if (BeeEntity.this.func_226437_j_(BeeEntity.this.field_226368_bH_)) {
                BeeEntity.this.field_226368_bH_ = null;
                return;
            }
            BeeEntity.this.func_226433_h_(BeeEntity.this.field_226368_bH_);
        }

        private boolean func_226482_j_() {
            return BeeEntity.this.field_226363_bC_ > 2400;
        }
    }

    public class FindBeehiveGoal
    extends PassiveGoal {
        private int field_226468_c_;
        private List<BlockPos> field_226469_d_;
        @Nullable
        private Path field_226470_e_;
        private int field_234183_f_;

        FindBeehiveGoal() {
            this.field_226468_c_ = BeeEntity.this.field_70170_p.field_73012_v.nextInt(10);
            this.field_226469_d_ = Lists.newArrayList();
            this.field_226470_e_ = null;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_225506_g_() {
            return BeeEntity.this.field_226369_bI_ != null && !BeeEntity.this.func_213394_dL() && BeeEntity.this.func_226415_eI_() && !this.func_226476_d_(BeeEntity.this.field_226369_bI_) && BeeEntity.this.field_70170_p.func_180495_p(BeeEntity.this.field_226369_bI_).func_235714_a_(BlockTags.field_226151_aa_);
        }

        @Override
        public boolean func_225507_h_() {
            return this.func_225506_g_();
        }

        @Override
        public void func_75249_e() {
            this.field_226468_c_ = 0;
            this.field_234183_f_ = 0;
            super.func_75249_e();
        }

        @Override
        public void func_75251_c() {
            this.field_226468_c_ = 0;
            this.field_234183_f_ = 0;
            BeeEntity.this.field_70699_by.func_75499_g();
            BeeEntity.this.field_70699_by.func_226336_g_();
        }

        @Override
        public void func_75246_d() {
            if (BeeEntity.this.field_226369_bI_ == null) {
                return;
            }
            ++this.field_226468_c_;
            if (this.field_226468_c_ > 600) {
                this.func_226478_k_();
                return;
            }
            if (BeeEntity.this.field_70699_by.func_226337_n_()) {
                return;
            }
            if (BeeEntity.this.func_226401_b_(BeeEntity.this.field_226369_bI_, 16)) {
                boolean bl = this.func_226472_a_(BeeEntity.this.field_226369_bI_);
                if (!bl) {
                    this.func_226478_k_();
                } else if (this.field_226470_e_ != null && BeeEntity.this.field_70699_by.func_75505_d().func_75876_a(this.field_226470_e_)) {
                    ++this.field_234183_f_;
                    if (this.field_234183_f_ > 60) {
                        this.func_226479_l_();
                        this.field_234183_f_ = 0;
                    }
                } else {
                    this.field_226470_e_ = BeeEntity.this.field_70699_by.func_75505_d();
                }
                return;
            }
            if (BeeEntity.this.func_226437_j_(BeeEntity.this.field_226369_bI_)) {
                this.func_226479_l_();
                return;
            }
            BeeEntity.this.func_226433_h_(BeeEntity.this.field_226369_bI_);
        }

        private boolean func_226472_a_(BlockPos blockPos) {
            BeeEntity.this.field_70699_by.func_226335_a_(10.0f);
            BeeEntity.this.field_70699_by.func_75492_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), 1.0);
            return BeeEntity.this.field_70699_by.func_75505_d() != null && BeeEntity.this.field_70699_by.func_75505_d().func_224771_h();
        }

        private boolean func_226473_b_(BlockPos blockPos) {
            return this.field_226469_d_.contains(blockPos);
        }

        private void func_226475_c_(BlockPos blockPos) {
            this.field_226469_d_.add(blockPos);
            while (this.field_226469_d_.size() > 3) {
                this.field_226469_d_.remove(0);
            }
        }

        private void func_226477_j_() {
            this.field_226469_d_.clear();
        }

        private void func_226478_k_() {
            if (BeeEntity.this.field_226369_bI_ != null) {
                this.func_226475_c_(BeeEntity.this.field_226369_bI_);
            }
            this.func_226479_l_();
        }

        private void func_226479_l_() {
            BeeEntity.this.field_226369_bI_ = null;
            BeeEntity.this.field_226366_bF_ = 200;
        }

        private boolean func_226476_d_(BlockPos blockPos) {
            if (BeeEntity.this.func_226401_b_(blockPos, 2)) {
                return true;
            }
            Path path = BeeEntity.this.field_70699_by.func_75505_d();
            return path != null && path.func_224770_k().equals(blockPos) && path.func_224771_h() && path.func_75879_b();
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            return BeeEntity.this.field_70699_by.func_75500_f() && BeeEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        @Override
        public boolean func_75253_b() {
            return BeeEntity.this.field_70699_by.func_226337_n_();
        }

        @Override
        public void func_75249_e() {
            Vector3d vector3d = this.func_226509_g_();
            if (vector3d != null) {
                BeeEntity.this.field_70699_by.func_75484_a(BeeEntity.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d func_226509_g_() {
            if (BeeEntity.this.func_226422_eP_() && !BeeEntity.this.func_226401_b_(BeeEntity.this.field_226369_bI_, 22)) {
                Vector3d vector3d = Vector3d.func_237489_a_(BeeEntity.this.field_226369_bI_);
                vector3d = vector3d.func_178788_d(BeeEntity.this.func_213303_ch()).func_72432_b();
            } else {
                Vector3d vector3d = BeeEntity.this.func_70676_i(0.0f);
            }
            int n = 8;
            Vector3d \u26032 = RandomPositionGenerator.func_226340_a_(BeeEntity.this, 8, 7, vector3d, 1.5707964f, 2, 1);
            if (\u26032 != null) {
                return \u26032;
            }
            return RandomPositionGenerator.func_226338_a_(BeeEntity.this, 8, 4, -2, vector3d, 1.5707963705062866);
        }
    }

    abstract class PassiveGoal
    extends Goal {
        private PassiveGoal() {
        }

        public abstract boolean func_225506_g_();

        public abstract boolean func_225507_h_();

        @Override
        public boolean func_75250_a() {
            return this.func_225506_g_() && !BeeEntity.this.func_233678_J__();
        }

        @Override
        public boolean func_75253_b() {
            return this.func_225507_h_() && !BeeEntity.this.func_233678_J__();
        }
    }

    static class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        AttackPlayerGoal(BeeEntity beeEntity) {
            super(beeEntity, PlayerEntity.class, 10, true, false, beeEntity::func_233680_b_);
        }

        @Override
        public boolean func_75250_a() {
            return this.func_226465_h_() && super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            boolean bl = this.func_226465_h_();
            if (!bl || this.field_75299_d.func_70638_az() == null) {
                this.field_188509_g = null;
                return false;
            }
            return super.func_75253_b();
        }

        private boolean func_226465_h_() {
            BeeEntity beeEntity = (BeeEntity)this.field_75299_d;
            return beeEntity.func_233678_J__() && !beeEntity.func_226412_eE_();
        }
    }

    class AngerGoal
    extends HurtByTargetGoal {
        AngerGoal(BeeEntity beeEntity2) {
            super(beeEntity2, new Class[0]);
        }

        @Override
        public boolean func_75253_b() {
            return BeeEntity.this.func_233678_J__() && super.func_75253_b();
        }

        @Override
        protected void func_220793_a(MobEntity mobEntity, LivingEntity livingEntity) {
            if (mobEntity instanceof BeeEntity && this.field_75299_d.func_70685_l(livingEntity)) {
                mobEntity.func_70624_b(livingEntity);
            }
        }
    }
}

