/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Logger;

public class ZombieVillagerEntity
extends ZombieEntity
implements IVillagerDataHolder {
    private static final DataParameter<Boolean> field_184739_bx = EntityDataManager.func_187226_a(ZombieVillagerEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<VillagerData> field_213795_c = EntityDataManager.func_187226_a(ZombieVillagerEntity.class, DataSerializers.field_218813_q);
    private int field_82234_d;
    private UUID field_191992_by;
    private INBT field_223728_bB;
    private CompoundNBT field_213793_bB;
    private int field_213794_bC;

    public ZombieVillagerEntity(EntityType<? extends ZombieVillagerEntity> entityType, World world) {
        super((EntityType<? extends ZombieEntity>)entityType, world);
        this.func_213792_a(this.func_213700_eh().func_221126_a(Registry.field_218370_L.func_186801_a(this.field_70146_Z)));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184739_bx, false);
        this.field_70180_af.func_187214_a(field_213795_c, new VillagerData(VillagerType.field_221175_c, VillagerProfession.field_221151_a, 1));
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        VillagerData.field_234554_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.func_213700_eh()).resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(iNBT -> compoundNBT.func_218657_a("VillagerData", (INBT)iNBT));
        if (this.field_213793_bB != null) {
            compoundNBT.func_218657_a("Offers", this.field_213793_bB);
        }
        if (this.field_223728_bB != null) {
            compoundNBT.func_218657_a("Gossips", this.field_223728_bB);
        }
        compoundNBT.func_74768_a("ConversionTime", this.func_82230_o() ? this.field_82234_d : -1);
        if (this.field_191992_by != null) {
            compoundNBT.func_186854_a("ConversionPlayer", this.field_191992_by);
        }
        compoundNBT.func_74768_a("Xp", this.field_213794_bC);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        super.func_70037_a(compoundNBT2);
        if (compoundNBT2.func_150297_b("VillagerData", 10)) {
            DataResult dataResult = VillagerData.field_234554_a_.parse(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundNBT2.func_74781_a("VillagerData")));
            dataResult.resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(this::func_213792_a);
        }
        if (compoundNBT2.func_150297_b("Offers", 10)) {
            this.field_213793_bB = compoundNBT2.func_74775_l("Offers");
        }
        if (compoundNBT2.func_150297_b("Gossips", 10)) {
            this.field_223728_bB = compoundNBT2.func_150295_c("Gossips", 10);
        }
        if (compoundNBT2.func_150297_b("ConversionTime", 99) && compoundNBT2.func_74762_e("ConversionTime") > -1) {
            this.func_191991_a(compoundNBT2.func_186855_b("ConversionPlayer") ? compoundNBT2.func_186857_a("ConversionPlayer") : null, compoundNBT2.func_74762_e("ConversionTime"));
        }
        if (compoundNBT2.func_150297_b("Xp", 3)) {
            this.field_213794_bC = compoundNBT2.func_74762_e("Xp");
        }
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_82230_o()) {
            int n = this.func_190735_dq();
            this.field_82234_d -= n;
            if (this.field_82234_d <= 0) {
                this.func_213791_a((ServerWorld)this.field_70170_p);
            }
        }
        super.func_70071_h_();
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (itemStack.func_77973_b() == Items.field_151153_ao) {
            if (this.func_70644_a(Effects.field_76437_t)) {
                if (!playerEntity.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_191991_a(playerEntity.func_110124_au(), this.field_70146_Z.nextInt(2401) + 3600);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return super.func_230254_b_(playerEntity, hand);
    }

    @Override
    protected boolean func_204703_dA() {
        return false;
    }

    @Override
    public boolean func_213397_c(double d) {
        return !this.func_82230_o() && this.field_213794_bC == 0;
    }

    public boolean func_82230_o() {
        return this.func_184212_Q().func_187225_a(field_184739_bx);
    }

    private void func_191991_a(@Nullable UUID uUID, int n) {
        this.field_191992_by = uUID;
        this.field_82234_d = n;
        this.func_184212_Q().func_187227_b(field_184739_bx, true);
        this.func_195063_d(Effects.field_76437_t);
        this.func_195064_c(new EffectInstance(Effects.field_76420_g, n, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.field_70170_p.func_72960_a(this, (byte)16);
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 16) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), SoundEvents.field_187942_hp, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            return;
        }
        super.func_70103_a(by);
    }

    private void func_213791_a(ServerWorld serverWorld) {
        VillagerEntity villagerEntity = this.func_233656_b_(EntityType.field_200756_av, false);
        for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
            ItemStack itemStack = this.func_184582_a(equipmentSlotType);
            if (itemStack.func_190926_b()) continue;
            if (EnchantmentHelper.func_190938_b(itemStack)) {
                villagerEntity.func_174820_d(equipmentSlotType.func_188454_b() + 300, itemStack);
                continue;
            }
            double \u26032 = this.func_205712_c(equipmentSlotType);
            if (!(\u26032 > 1.0)) continue;
            this.func_199701_a_(itemStack);
        }
        villagerEntity.func_213753_a(this.func_213700_eh());
        if (this.field_223728_bB != null) {
            villagerEntity.func_223716_a(this.field_223728_bB);
        }
        if (this.field_213793_bB != null) {
            villagerEntity.func_213768_b(new MerchantOffers(this.field_213793_bB));
        }
        villagerEntity.func_213761_t(this.field_213794_bC);
        villagerEntity.func_213386_a(serverWorld, serverWorld.func_175649_E(villagerEntity.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        if (this.field_191992_by != null && (\u2603 = serverWorld.func_217371_b(this.field_191992_by)) instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192137_q.func_192183_a((ServerPlayerEntity)\u2603, this, villagerEntity);
            serverWorld.func_217489_a(IReputationType.field_221029_a, \u2603, villagerEntity);
        }
        villagerEntity.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
        if (!this.func_174814_R()) {
            serverWorld.func_217378_a(null, 1027, this.func_233580_cy_(), 0);
        }
    }

    private int func_190735_dq() {
        int n = 1;
        if (this.field_70146_Z.nextFloat() < 0.01f) {
            \u2603 = 0;
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int i = (int)this.func_226277_ct_() - 4; i < (int)this.func_226277_ct_() + 4 && \u2603 < 14; ++i) {
                for (\u2603 = (int)this.func_226278_cu_() - 4; \u2603 < (int)this.func_226278_cu_() + 4 && \u2603 < 14; ++\u2603) {
                    for (\u2603 = (int)this.func_226281_cx_() - 4; \u2603 < (int)this.func_226281_cx_() + 4 && \u2603 < 14; ++\u2603) {
                        Block block = this.field_70170_p.func_180495_p(mutable.func_181079_c(i, \u2603, \u2603)).func_177230_c();
                        if (block != Blocks.field_150411_aY && !(block instanceof BedBlock)) continue;
                        if (this.field_70146_Z.nextFloat() < 0.3f) {
                            ++n;
                        }
                        ++\u2603;
                    }
                }
            }
        }
        return n;
    }

    @Override
    protected float func_70647_i() {
        if (this.func_70631_g_()) {
            return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 2.0f;
        }
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEvent func_184639_G() {
        return SoundEvents.field_187940_hn;
    }

    @Override
    public SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187944_hr;
    }

    @Override
    public SoundEvent func_184615_bR() {
        return SoundEvents.field_187943_hq;
    }

    @Override
    public SoundEvent func_190731_di() {
        return SoundEvents.field_187946_ht;
    }

    @Override
    protected ItemStack func_190732_dj() {
        return ItemStack.field_190927_a;
    }

    public void func_213790_g(CompoundNBT compoundNBT) {
        this.field_213793_bB = compoundNBT;
    }

    public void func_223727_a(INBT iNBT) {
        this.field_223728_bB = iNBT;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.func_213792_a(this.func_213700_eh().func_221134_a(VillagerType.func_242371_a(iServerWorld.func_242406_i(this.func_233580_cy_()))));
        return super.func_213386_a(iServerWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    public void func_213792_a(VillagerData villagerData) {
        \u2603 = this.func_213700_eh();
        if (\u2603.func_221130_b() != villagerData.func_221130_b()) {
            this.field_213793_bB = null;
        }
        this.field_70180_af.func_187227_b(field_213795_c, villagerData);
    }

    @Override
    public VillagerData func_213700_eh() {
        return this.field_70180_af.func_187225_a(field_213795_c);
    }

    public void func_213789_a(int n) {
        this.field_213794_bC = n;
    }
}

