/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import io.netty.util.internal.ThreadLocalRandom;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeModifier {
    private static final Logger field_233799_a_ = LogManager.getLogger();
    private final double field_111174_a;
    private final Operation field_111172_b;
    private final Supplier<String> field_111173_c;
    private final UUID field_111170_d;

    public AttributeModifier(String string, double d, Operation operation) {
        this(MathHelper.func_180182_a((Random)ThreadLocalRandom.current()), () -> string, d, operation);
    }

    public AttributeModifier(UUID uUID, String string, double d, Operation operation) {
        this(uUID, () -> string, d, operation);
    }

    public AttributeModifier(UUID uUID, Supplier<String> supplier, double d, Operation operation) {
        this.field_111170_d = uUID;
        this.field_111173_c = supplier;
        this.field_111174_a = d;
        this.field_111172_b = operation;
    }

    public UUID func_111167_a() {
        return this.field_111170_d;
    }

    public String func_111166_b() {
        return this.field_111173_c.get();
    }

    public Operation func_220375_c() {
        return this.field_111172_b;
    }

    public double func_111164_d() {
        return this.field_111174_a;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AttributeModifier attributeModifier = (AttributeModifier)object;
        return Objects.equals(this.field_111170_d, attributeModifier.field_111170_d);
    }

    public int hashCode() {
        return this.field_111170_d.hashCode();
    }

    public String toString() {
        return "AttributeModifier{amount=" + this.field_111174_a + ", operation=" + (Object)((Object)this.field_111172_b) + ", name='" + this.field_111173_c.get() + '\'' + ", id=" + this.field_111170_d + '}';
    }

    public CompoundNBT func_233801_e_() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("Name", this.func_111166_b());
        compoundNBT.func_74780_a("Amount", this.field_111174_a);
        compoundNBT.func_74768_a("Operation", this.field_111172_b.func_220371_a());
        compoundNBT.func_186854_a("UUID", this.field_111170_d);
        return compoundNBT;
    }

    @Nullable
    public static AttributeModifier func_233800_a_(CompoundNBT compoundNBT) {
        try {
            UUID uUID = compoundNBT.func_186857_a("UUID");
            Operation \u26032 = Operation.func_220372_a(compoundNBT.func_74762_e("Operation"));
            return new AttributeModifier(uUID, compoundNBT.func_74779_i("Name"), compoundNBT.func_74769_h("Amount"), \u26032);
        }
        catch (Exception exception) {
            field_233799_a_.warn("Unable to create attribute: {}", (Object)exception.getMessage());
            return null;
        }
    }

    public static enum Operation {
        ADDITION(0),
        MULTIPLY_BASE(1),
        MULTIPLY_TOTAL(2);

        private static final Operation[] field_220373_d;
        private final int field_220374_e;

        private Operation(int n2) {
            this.field_220374_e = n2;
        }

        public int func_220371_a() {
            return this.field_220374_e;
        }

        public static Operation func_220372_a(int n) {
            if (n < 0 || n >= field_220373_d.length) {
                throw new IllegalArgumentException("No operation with value " + n);
            }
            return field_220373_d[n];
        }

        static {
            field_220373_d = new Operation[]{ADDITION, MULTIPLY_BASE, MULTIPLY_TOTAL};
        }
    }
}

