/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.Util;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SNBTToNBTConverter
implements IDataProvider {
    @Nullable
    private static final Path field_240514_b_ = null;
    private static final Logger field_200424_a = LogManager.getLogger();
    private final DataGenerator field_200425_b;
    private final List<ITransformer> field_225370_d = Lists.newArrayList();

    public SNBTToNBTConverter(DataGenerator dataGenerator) {
        this.field_200425_b = dataGenerator;
    }

    public SNBTToNBTConverter func_225369_a(ITransformer iTransformer) {
        this.field_225370_d.add(iTransformer);
        return this;
    }

    private CompoundNBT func_225368_a(String string, CompoundNBT compoundNBT) {
        CompoundNBT compoundNBT2;
        compoundNBT2 = compoundNBT;
        for (ITransformer iTransformer : this.field_225370_d) {
            compoundNBT2 = iTransformer.func_225371_a(string, compoundNBT2);
        }
        return compoundNBT2;
    }

    @Override
    public void func_200398_a(DirectoryCache directoryCache) throws IOException {
        Path path3 = this.field_200425_b.func_200391_b();
        ArrayList \u26032 = Lists.newArrayList();
        for (Path path4 : this.field_200425_b.func_200389_a()) {
            Files.walk(path4, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".snbt")).forEach(path2 -> \u26032.add(CompletableFuture.supplyAsync(() -> this.func_229446_a_((Path)path2, this.func_200423_a(path4, (Path)path2)), Util.func_215072_e())));
        }
        Util.func_215079_b(\u26032).join().stream().filter(Objects::nonNull).forEach(taskResult -> this.func_229444_a_(directoryCache, (TaskResult)taskResult, path3));
    }

    @Override
    public String func_200397_b() {
        return "SNBT -> NBT";
    }

    private String func_200423_a(Path path, Path path2) {
        String string = path.relativize(path2).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".snbt".length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private TaskResult func_229446_a_(Path path, String string) {
        try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
            String \u26037;
            String \u26032 = IOUtils.toString((Reader)bufferedReader);
            CompoundNBT \u26033 = this.func_225368_a(string, JsonToNBT.func_180713_a(\u26032));
            ByteArrayOutputStream \u26034 = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a(\u26033, \u26034);
            byte[] \u26035 = \u26034.toByteArray();
            String \u26036 = field_208307_a.hashBytes(\u26035).toString();
            if (field_240514_b_ != null) {
                String string2 = \u26033.func_199850_a("    ", 0).getString() + "\n";
            } else {
                \u26037 = null;
            }
            TaskResult taskResult = new TaskResult(string, \u26035, \u26037, \u26036);
            return taskResult;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            field_200424_a.error("Couldn't convert {} from SNBT to NBT at {} as it's invalid SNBT", (Object)string, (Object)path, (Object)commandSyntaxException);
            return null;
        }
        catch (IOException iOException) {
            field_200424_a.error("Couldn't convert {} from SNBT to NBT at {}", (Object)string, (Object)path, (Object)iOException);
        }
        return null;
    }

    private void func_229444_a_(DirectoryCache directoryCache2, TaskResult taskResult, Path path2) {
        Path path2;
        if (taskResult.field_240515_c_ != null) {
            \u2603 = field_240514_b_.resolve(taskResult.field_229449_a_ + ".snbt");
            try {
                FileUtils.write((File)\u2603.toFile(), (CharSequence)taskResult.field_240515_c_, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                field_200424_a.error("Couldn't write structure SNBT {} at {}", (Object)taskResult.field_229449_a_, (Object)\u2603, (Object)iOException);
            }
        }
        \u2603 = path2.resolve(taskResult.field_229449_a_ + ".nbt");
        try {
            DirectoryCache directoryCache2;
            if (!Objects.equals(directoryCache2.func_208323_a(\u2603), taskResult.field_229451_c_) || !Files.exists(\u2603, new LinkOption[0])) {
                Files.createDirectories(\u2603.getParent(), new FileAttribute[0]);
                try (OutputStream outputStream = Files.newOutputStream(\u2603, new OpenOption[0]);){
                    outputStream.write(taskResult.field_229450_b_);
                }
            }
            directoryCache2.func_208316_a(\u2603, taskResult.field_229451_c_);
        }
        catch (IOException iOException) {
            field_200424_a.error("Couldn't write structure {} at {}", (Object)taskResult.field_229449_a_, (Object)\u2603, (Object)iOException);
        }
    }

    @FunctionalInterface
    public static interface ITransformer {
        public CompoundNBT func_225371_a(String var1, CompoundNBT var2);
    }

    static class TaskResult {
        private final String field_229449_a_;
        private final byte[] field_229450_b_;
        @Nullable
        private final String field_240515_c_;
        private final String field_229451_c_;

        public TaskResult(String string, byte[] byArray, @Nullable String string2, String string3) {
            this.field_229449_a_ = string;
            this.field_229450_b_ = byArray;
            this.field_240515_c_ = string2;
            this.field_229451_c_ = string3;
        }
    }
}

