/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceIndex {
    protected static final Logger field_152783_a = LogManager.getLogger();
    private final Map<String, File> field_229271_b_ = Maps.newHashMap();
    private final Map<ResourceLocation, File> field_229272_c_ = Maps.newHashMap();

    protected ResourceIndex() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceIndex(File file, String string) {
        File file2 = new File(file, "objects");
        \u2603 = new File(file, "indexes/" + string + ".json");
        BufferedReader \u26032 = null;
        try {
            \u26032 = Files.newReader((File)\u2603, (Charset)StandardCharsets.UTF_8);
            JsonObject jsonObject = JSONUtils.func_212743_a(\u26032);
            \u2603 = JSONUtils.func_151218_a(jsonObject, "objects", null);
            if (\u2603 != null) {
                for (Map.Entry entry : \u2603.entrySet()) {
                    JsonObject jsonObject2 = (JsonObject)entry.getValue();
                    String \u26033 = (String)entry.getKey();
                    String[] \u26034 = \u26033.split("/", 2);
                    String \u26035 = JSONUtils.func_151200_h(jsonObject2, "hash");
                    File \u26036 = new File(file2, \u26035.substring(0, 2) + "/" + \u26035);
                    if (\u26034.length == 1) {
                        this.field_229271_b_.put(\u26034[0], \u26036);
                        continue;
                    }
                    this.field_229272_c_.put(new ResourceLocation(\u26034[0], \u26034[1]), \u26036);
                }
            }
        }
        catch (JsonParseException jsonParseException) {
            field_152783_a.error("Unable to parse resource index file: {}", (Object)\u2603);
        }
        catch (FileNotFoundException fileNotFoundException) {
            field_152783_a.error("Can't find the resource index file: {}", (Object)\u2603);
        }
        finally {
            IOUtils.closeQuietly((Reader)\u26032);
        }
    }

    @Nullable
    public File func_188547_a(ResourceLocation resourceLocation) {
        return this.field_229272_c_.get(resourceLocation);
    }

    @Nullable
    public File func_225638_a_(String string) {
        return this.field_229271_b_.get(string);
    }

    public Collection<ResourceLocation> func_225639_a_(String string, String string2, int n, Predicate<String> predicate) {
        return this.field_229272_c_.keySet().stream().filter(resourceLocation -> {
            String string3 = resourceLocation.func_110623_a();
            return resourceLocation.func_110624_b().equals(string2) && !string3.endsWith(".mcmeta") && string3.startsWith(string + "/") && predicate.test(string3);
        }).collect(Collectors.toList());
    }
}

