/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AtlasTexture
extends Texture
implements ITickable {
    private static final Logger field_147635_d = LogManager.getLogger();
    @Deprecated
    public static final ResourceLocation field_110575_b = PlayerContainer.field_226615_c_;
    @Deprecated
    public static final ResourceLocation field_215262_g = new ResourceLocation("textures/atlas/particles.png");
    private final List<TextureAtlasSprite> field_94258_i = Lists.newArrayList();
    private final Set<ResourceLocation> field_195427_i = Sets.newHashSet();
    private final Map<ResourceLocation, TextureAtlasSprite> field_94252_e = Maps.newHashMap();
    private final ResourceLocation field_229214_j_;
    private final int field_215265_o;

    public AtlasTexture(ResourceLocation resourceLocation) {
        this.field_229214_j_ = resourceLocation;
        this.field_215265_o = RenderSystem.maxSupportedTextureSize();
    }

    @Override
    public void func_195413_a(IResourceManager iResourceManager) throws IOException {
    }

    public void func_215260_a(SheetData sheetData) {
        this.field_195427_i.clear();
        this.field_195427_i.addAll(sheetData.field_217805_a);
        field_147635_d.info("Created: {}x{}x{} {}-atlas", (Object)sheetData.field_217806_b, (Object)sheetData.field_217807_c, (Object)sheetData.field_229224_d_, (Object)this.field_229214_j_);
        TextureUtil.func_225681_a_(this.func_110552_b(), sheetData.field_229224_d_, sheetData.field_217806_b, sheetData.field_217807_c);
        this.func_195419_g();
        for (TextureAtlasSprite textureAtlasSprite : sheetData.field_217808_d) {
            this.field_94252_e.put(textureAtlasSprite.func_195668_m(), textureAtlasSprite);
            try {
                textureAtlasSprite.func_195663_q();
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Stitching texture atlas");
                CrashReportCategory \u26032 = crashReport.func_85058_a("Texture being stitched together");
                \u26032.func_71507_a("Atlas path", this.field_229214_j_);
                \u26032.func_71507_a("Sprite", textureAtlasSprite);
                throw new ReportedException(crashReport);
            }
            if (!textureAtlasSprite.func_130098_m()) continue;
            this.field_94258_i.add(textureAtlasSprite);
        }
    }

    public SheetData func_229220_a_(IResourceManager iResourceManager, Stream<ResourceLocation> stream, IProfiler iProfiler, int n) {
        iProfiler.func_76320_a("preparing");
        Set<ResourceLocation> set = stream.peek(resourceLocation -> {
            if (resourceLocation == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
        }).collect(Collectors.toSet());
        int \u26032 = this.field_215265_o;
        Stitcher \u26033 = new Stitcher(\u26032, \u26032, n);
        int \u26034 = Integer.MAX_VALUE;
        int \u26035 = 1 << n;
        iProfiler.func_219895_b("extracting_frames");
        for (TextureAtlasSprite.Info info2 : this.func_215256_a(iResourceManager, set)) {
            \u26034 = Math.min(\u26034, Math.min(info2.func_229250_b_(), info2.func_229252_c_()));
            int n2 = Math.min(Integer.lowestOneBit(info2.func_229250_b_()), Integer.lowestOneBit(info2.func_229252_c_()));
            if (n2 < \u26035) {
                field_147635_d.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)info2.func_229248_a_(), (Object)info2.func_229250_b_(), (Object)info2.func_229252_c_(), (Object)MathHelper.func_151239_c(\u26035), (Object)MathHelper.func_151239_c(n2));
                \u26035 = n2;
            }
            \u26033.func_229211_a_(info2);
        }
        int n3 = Math.min(\u26034, \u26035);
        \u2603 = MathHelper.func_151239_c(n3);
        if (\u2603 < n) {
            field_147635_d.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", (Object)this.field_229214_j_, (Object)n, (Object)\u2603, (Object)n3);
            n2 = \u2603;
        } else {
            n2 = n;
        }
        iProfiler.func_219895_b("register");
        \u26033.func_229211_a_(MissingTextureSprite.func_229177_b_());
        iProfiler.func_219895_b("stitching");
        try {
            \u26033.func_94305_f();
        }
        catch (StitcherException \u26036) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26036, "Stitching");
            CrashReportCategory \u26037 = crashReport.func_85058_a("Stitcher");
            \u26037.func_71507_a("Sprites", \u26036.func_225331_a().stream().map(info -> String.format("%s[%dx%d]", info.func_229248_a_(), info.func_229250_b_(), info.func_229252_c_())).collect(Collectors.joining(",")));
            \u26037.func_71507_a("Max Texture Size", \u26032);
            throw new ReportedException(crashReport);
        }
        iProfiler.func_219895_b("loading");
        List<TextureAtlasSprite> list = this.func_229217_a_(iResourceManager, \u26033, n2);
        iProfiler.func_76319_b();
        return new SheetData(set, \u26033.func_110935_a(), \u26033.func_110936_b(), n2, list);
    }

    private Collection<TextureAtlasSprite.Info> func_215256_a(IResourceManager iResourceManager, Set<ResourceLocation> set) {
        ArrayList arrayList = Lists.newArrayList();
        ConcurrentLinkedQueue<TextureAtlasSprite.Info> \u26032 = new ConcurrentLinkedQueue<TextureAtlasSprite.Info>();
        for (ResourceLocation resourceLocation : set) {
            if (MissingTextureSprite.func_195675_b().equals(resourceLocation)) continue;
            arrayList.add(CompletableFuture.runAsync(() -> {
                TextureAtlasSprite.Info \u26034;
                ResourceLocation resourceLocation2 = this.func_195420_b(resourceLocation);
                try (IResource iResource = iResourceManager.func_199002_a(resourceLocation2);){
                    PngSizeInfo pngSizeInfo = new PngSizeInfo(iResource.toString(), iResource.func_199027_b());
                    AnimationMetadataSection \u26032 = iResource.func_199028_a(AnimationMetadataSection.field_195817_a);
                    if (\u26032 == null) {
                        \u26032 = AnimationMetadataSection.field_229300_b_;
                    }
                    Pair<Integer, Integer> \u26033 = \u26032.func_225641_a_(pngSizeInfo.field_188533_a, pngSizeInfo.field_188534_b);
                    \u26034 = new TextureAtlasSprite.Info(resourceLocation, (Integer)\u26033.getFirst(), (Integer)\u26033.getSecond(), \u26032);
                }
                catch (RuntimeException runtimeException) {
                    field_147635_d.error("Unable to parse metadata from {} : {}", (Object)resourceLocation2, (Object)runtimeException);
                    return;
                }
                catch (IOException iOException) {
                    field_147635_d.error("Using missing texture, unable to load {} : {}", (Object)resourceLocation2, (Object)iOException);
                    return;
                }
                \u26032.add(\u26034);
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0])).join();
        return \u26032;
    }

    private List<TextureAtlasSprite> func_229217_a_(IResourceManager iResourceManager, Stitcher stitcher, int n) {
        ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
        ArrayList \u26032 = Lists.newArrayList();
        stitcher.func_229209_a_((info, n2, n3, n4, n5) -> {
            if (info == MissingTextureSprite.func_229177_b_()) {
                MissingTextureSprite missingTextureSprite = MissingTextureSprite.func_229176_a_(this, n, n2, n3, n4, n5);
                concurrentLinkedQueue.add(missingTextureSprite);
            } else {
                List list2;
                \u26032.add(CompletableFuture.runAsync(() -> {
                    TextureAtlasSprite textureAtlasSprite = this.func_229218_a_(iResourceManager, info, n2, n3, n, n4, n5);
                    if (textureAtlasSprite != null) {
                        concurrentLinkedQueue.add(textureAtlasSprite);
                    }
                }, Util.func_215072_e()));
            }
        });
        CompletableFuture.allOf(\u26032.toArray(new CompletableFuture[0])).join();
        return Lists.newArrayList(concurrentLinkedQueue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private TextureAtlasSprite func_229218_a_(IResourceManager iResourceManager, TextureAtlasSprite.Info info, int n, int n2, int n3, int n4, int n5) {
        ResourceLocation resourceLocation = this.func_195420_b(info.func_229248_a_());
        try (IResource \u26032 = iResourceManager.func_199002_a(resourceLocation);){
            NativeImage \u26033 = NativeImage.func_195713_a(\u26032.func_199027_b());
            TextureAtlasSprite textureAtlasSprite = new TextureAtlasSprite(this, info, n3, n, n2, n4, n5, \u26033);
            return textureAtlasSprite;
        }
        catch (RuntimeException runtimeException) {
            field_147635_d.error("Unable to parse metadata from {}", (Object)resourceLocation, (Object)runtimeException);
            return null;
        }
        catch (IOException iOException) {
            field_147635_d.error("Using missing texture, unable to load {}", (Object)resourceLocation, (Object)iOException);
            return null;
        }
    }

    private ResourceLocation func_195420_b(ResourceLocation resourceLocation) {
        return new ResourceLocation(resourceLocation.func_110624_b(), String.format("textures/%s%s", resourceLocation.func_110623_a(), ".png"));
    }

    public void func_94248_c() {
        this.func_229148_d_();
        for (TextureAtlasSprite textureAtlasSprite : this.field_94258_i) {
            textureAtlasSprite.func_94219_l();
        }
    }

    @Override
    public void func_110550_d() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::func_94248_c);
        } else {
            this.func_94248_c();
        }
    }

    public TextureAtlasSprite func_195424_a(ResourceLocation resourceLocation) {
        TextureAtlasSprite textureAtlasSprite = this.field_94252_e.get(resourceLocation);
        if (textureAtlasSprite == null) {
            return this.field_94252_e.get(MissingTextureSprite.func_195675_b());
        }
        return textureAtlasSprite;
    }

    public void func_195419_g() {
        for (TextureAtlasSprite textureAtlasSprite : this.field_94252_e.values()) {
            textureAtlasSprite.close();
        }
        this.field_94252_e.clear();
        this.field_94258_i.clear();
    }

    public ResourceLocation func_229223_g_() {
        return this.field_229214_j_;
    }

    public void func_229221_b_(SheetData sheetData) {
        this.func_174937_a(false, sheetData.field_229224_d_ > 0);
    }

    public static class SheetData {
        final Set<ResourceLocation> field_217805_a;
        final int field_217806_b;
        final int field_217807_c;
        final int field_229224_d_;
        final List<TextureAtlasSprite> field_217808_d;

        public SheetData(Set<ResourceLocation> set, int n, int n2, int n3, List<TextureAtlasSprite> list) {
            this.field_217805_a = set;
            this.field_217806_b = n;
            this.field_217807_c = n2;
            this.field_229224_d_ = n3;
            this.field_217808_d = list;
        }
    }
}

