/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BipedArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();
    private final A field_177189_c;
    private final A field_177186_d;

    public BipedArmorLayer(IEntityRenderer<T, M> iEntityRenderer, A a, A a2) {
        super(iEntityRenderer);
        this.field_177189_c = a;
        this.field_177186_d = a2;
    }

    @Override
    public void func_225628_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, T t, float f, float f2, float f3, float f4, float f5, float f6) {
        this.func_241739_a_(matrixStack, iRenderTypeBuffer, t, EquipmentSlotType.CHEST, n, this.func_241736_a_(EquipmentSlotType.CHEST));
        this.func_241739_a_(matrixStack, iRenderTypeBuffer, t, EquipmentSlotType.LEGS, n, this.func_241736_a_(EquipmentSlotType.LEGS));
        this.func_241739_a_(matrixStack, iRenderTypeBuffer, t, EquipmentSlotType.FEET, n, this.func_241736_a_(EquipmentSlotType.FEET));
        this.func_241739_a_(matrixStack, iRenderTypeBuffer, t, EquipmentSlotType.HEAD, n, this.func_241736_a_(EquipmentSlotType.HEAD));
    }

    private void func_241739_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, T t, EquipmentSlotType equipmentSlotType, int n, A a) {
        ItemStack itemStack = ((LivingEntity)t).func_184582_a(equipmentSlotType);
        if (!(itemStack.func_77973_b() instanceof ArmorItem)) {
            return;
        }
        ArmorItem \u26032 = (ArmorItem)itemStack.func_77973_b();
        if (\u26032.func_185083_B_() != equipmentSlotType) {
            return;
        }
        ((BipedModel)this.func_215332_c()).func_217148_a(a);
        this.func_188359_a(a, equipmentSlotType);
        boolean \u26033 = this.func_188363_b(equipmentSlotType);
        boolean \u26034 = itemStack.func_77962_s();
        if (\u26032 instanceof DyeableArmorItem) {
            int n2 = ((DyeableArmorItem)\u26032).func_200886_f(itemStack);
            float \u26035 = (float)(n2 >> 16 & 0xFF) / 255.0f;
            float \u26036 = (float)(n2 >> 8 & 0xFF) / 255.0f;
            float \u26037 = (float)(n2 & 0xFF) / 255.0f;
            this.func_241738_a_(matrixStack, iRenderTypeBuffer, n, \u26032, \u26034, a, \u26033, \u26035, \u26036, \u26037, null);
            this.func_241738_a_(matrixStack, iRenderTypeBuffer, n, \u26032, \u26034, a, \u26033, 1.0f, 1.0f, 1.0f, "overlay");
        } else {
            this.func_241738_a_(matrixStack, iRenderTypeBuffer, n, \u26032, \u26034, a, \u26033, 1.0f, 1.0f, 1.0f, null);
        }
    }

    protected void func_188359_a(A a, EquipmentSlotType equipmentSlotType) {
        ((BipedModel)a).func_178719_a(false);
        switch (equipmentSlotType) {
            case HEAD: {
                ((BipedModel)a).field_78116_c.field_78806_j = true;
                ((BipedModel)a).field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                ((BipedModel)a).field_78115_e.field_78806_j = true;
                ((BipedModel)a).field_178723_h.field_78806_j = true;
                ((BipedModel)a).field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                ((BipedModel)a).field_78115_e.field_78806_j = true;
                ((BipedModel)a).field_178721_j.field_78806_j = true;
                ((BipedModel)a).field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                ((BipedModel)a).field_178721_j.field_78806_j = true;
                ((BipedModel)a).field_178722_k.field_78806_j = true;
            }
        }
    }

    private void func_241738_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, ArmorItem armorItem, boolean bl, A a, boolean bl2, float f, float f2, float f3, @Nullable String string) {
        IVertexBuilder iVertexBuilder = ItemRenderer.func_239386_a_(iRenderTypeBuffer, RenderType.func_239263_a_(this.func_241737_a_(armorItem, bl2, string)), false, bl);
        ((AgeableModel)a).func_225598_a_(matrixStack, iVertexBuilder, n, OverlayTexture.field_229196_a_, f, f2, f3, 1.0f);
    }

    private A func_241736_a_(EquipmentSlotType equipmentSlotType) {
        return this.func_188363_b(equipmentSlotType) ? this.field_177189_c : this.field_177186_d;
    }

    private boolean func_188363_b(EquipmentSlotType equipmentSlotType) {
        return equipmentSlotType == EquipmentSlotType.LEGS;
    }

    private ResourceLocation func_241737_a_(ArmorItem armorItem, boolean bl, @Nullable String string) {
        \u2603 = "textures/models/armor/" + armorItem.func_200880_d().func_200897_d() + "_layer_" + (bl ? 2 : 1) + (string == null ? "" : "_" + string) + ".png";
        return field_177191_j.computeIfAbsent(\u2603, ResourceLocation::new);
    }
}

