/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5HeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.ParrotVariantLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.scoreboard.Score;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PlayerRenderer
extends LivingRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public PlayerRenderer(EntityRendererManager entityRendererManager) {
        this(entityRendererManager, false);
    }

    public PlayerRenderer(EntityRendererManager entityRendererManager, boolean bl) {
        super(entityRendererManager, new PlayerModel(0.0f, bl), 0.5f);
        this.func_177094_a(new BipedArmorLayer(this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a(new HeldItemLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new ArrowLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new Deadmau5HeadLayer(this));
        this.func_177094_a(new CapeLayer(this));
        this.func_177094_a(new HeadLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new ElytraLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new ParrotVariantLayer<AbstractClientPlayerEntity>(this));
        this.func_177094_a(new SpinAttackEffectLayer<AbstractClientPlayerEntity>(this));
        this.func_177094_a(new BeeStingerLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
    }

    @Override
    public void func_225623_a_(AbstractClientPlayerEntity abstractClientPlayerEntity, float f, float f2, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n) {
        this.func_177137_d(abstractClientPlayerEntity);
        super.func_225623_a_(abstractClientPlayerEntity, f, f2, matrixStack, iRenderTypeBuffer, n);
    }

    @Override
    public Vector3d func_225627_b_(AbstractClientPlayerEntity abstractClientPlayerEntity, float f) {
        if (abstractClientPlayerEntity.func_213453_ef()) {
            return new Vector3d(0.0, -0.125, 0.0);
        }
        return super.func_225627_b_(abstractClientPlayerEntity, f);
    }

    private void func_177137_d(AbstractClientPlayerEntity abstractClientPlayerEntity) {
        PlayerModel playerModel = (PlayerModel)this.func_217764_d();
        if (abstractClientPlayerEntity.func_175149_v()) {
            playerModel.func_178719_a(false);
            playerModel.field_78116_c.field_78806_j = true;
            playerModel.field_178720_f.field_78806_j = true;
        } else {
            playerModel.func_178719_a(true);
            playerModel.field_178720_f.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.HAT);
            playerModel.field_178730_v.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.JACKET);
            playerModel.field_178733_c.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.LEFT_PANTS_LEG);
            playerModel.field_178731_d.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.RIGHT_PANTS_LEG);
            playerModel.field_178734_a.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.LEFT_SLEEVE);
            playerModel.field_178732_b.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.RIGHT_SLEEVE);
            playerModel.field_228270_o_ = abstractClientPlayerEntity.func_213453_ef();
            BipedModel.ArmPose armPose = PlayerRenderer.func_241741_a_(abstractClientPlayerEntity, Hand.MAIN_HAND);
            \u2603 = PlayerRenderer.func_241741_a_(abstractClientPlayerEntity, Hand.OFF_HAND);
            if (armPose.func_241657_a_()) {
                BipedModel.ArmPose armPose2 = \u2603 = abstractClientPlayerEntity.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
            }
            if (abstractClientPlayerEntity.func_184591_cq() == HandSide.RIGHT) {
                playerModel.field_187076_m = armPose;
                playerModel.field_187075_l = \u2603;
            } else {
                playerModel.field_187076_m = \u2603;
                playerModel.field_187075_l = armPose;
            }
        }
    }

    private static BipedModel.ArmPose func_241741_a_(AbstractClientPlayerEntity abstractClientPlayerEntity2, Hand hand) {
        AbstractClientPlayerEntity abstractClientPlayerEntity2;
        ItemStack itemStack = abstractClientPlayerEntity2.func_184586_b(hand);
        if (itemStack.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (abstractClientPlayerEntity2.func_184600_cs() == hand && abstractClientPlayerEntity2.func_184605_cv() > 0) {
            UseAction useAction = itemStack.func_77975_n();
            if (useAction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useAction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAction == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useAction == UseAction.CROSSBOW && hand == abstractClientPlayerEntity2.func_184600_cs()) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!abstractClientPlayerEntity2.field_82175_bq && itemStack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d(itemStack)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }

    @Override
    public ResourceLocation func_110775_a(AbstractClientPlayerEntity abstractClientPlayerEntity) {
        return abstractClientPlayerEntity.func_110306_p();
    }

    @Override
    protected void func_225620_a_(AbstractClientPlayerEntity abstractClientPlayerEntity, MatrixStack matrixStack, float f) {
        \u2603 = 0.9375f;
        matrixStack.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
    }

    @Override
    protected void func_225629_a_(AbstractClientPlayerEntity abstractClientPlayerEntity2, ITextComponent iTextComponent, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n) {
        AbstractClientPlayerEntity abstractClientPlayerEntity2;
        double d = this.field_76990_c.func_229099_b_(abstractClientPlayerEntity2);
        matrixStack.func_227860_a_();
        if (d < 100.0 && (\u2603 = (\u2603 = abstractClientPlayerEntity2.func_96123_co()).func_96539_a(2)) != null) {
            Score score = \u2603.func_96529_a(abstractClientPlayerEntity2.func_195047_I_(), \u2603);
            super.func_225629_a_(abstractClientPlayerEntity2, new StringTextComponent(Integer.toString(score.func_96652_c())).func_240702_b_(" ").func_230529_a_(\u2603.func_96678_d()), matrixStack, iRenderTypeBuffer, n);
            this.func_76983_a().getClass();
            matrixStack.func_227861_a_(0.0, 9.0f * 1.15f * 0.025f, 0.0);
        }
        super.func_225629_a_(abstractClientPlayerEntity2, iTextComponent, matrixStack, iRenderTypeBuffer, n);
        matrixStack.func_227865_b_();
    }

    public void func_229144_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, AbstractClientPlayerEntity abstractClientPlayerEntity) {
        this.func_229145_a_(matrixStack, iRenderTypeBuffer, n, abstractClientPlayerEntity, ((PlayerModel)this.field_77045_g).field_178723_h, ((PlayerModel)this.field_77045_g).field_178732_b);
    }

    public void func_229146_b_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, AbstractClientPlayerEntity abstractClientPlayerEntity) {
        this.func_229145_a_(matrixStack, iRenderTypeBuffer, n, abstractClientPlayerEntity, ((PlayerModel)this.field_77045_g).field_178724_i, ((PlayerModel)this.field_77045_g).field_178734_a);
    }

    private void func_229145_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, AbstractClientPlayerEntity abstractClientPlayerEntity, ModelRenderer modelRenderer, ModelRenderer modelRenderer2) {
        PlayerModel playerModel = (PlayerModel)this.func_217764_d();
        this.func_177137_d(abstractClientPlayerEntity);
        playerModel.field_217112_c = 0.0f;
        playerModel.field_228270_o_ = false;
        playerModel.field_205061_a = 0.0f;
        playerModel.func_225597_a_(abstractClientPlayerEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        modelRenderer.field_78795_f = 0.0f;
        modelRenderer.func_228308_a_(matrixStack, iRenderTypeBuffer.getBuffer(RenderType.func_228634_a_(abstractClientPlayerEntity.func_110306_p())), n, OverlayTexture.field_229196_a_);
        modelRenderer2.field_78795_f = 0.0f;
        modelRenderer2.func_228308_a_(matrixStack, iRenderTypeBuffer.getBuffer(RenderType.func_228644_e_(abstractClientPlayerEntity.func_110306_p())), n, OverlayTexture.field_229196_a_);
    }

    @Override
    protected void func_225621_a_(AbstractClientPlayerEntity abstractClientPlayerEntity, MatrixStack matrixStack, float f, float f2, float f3) {
        float f4;
        f4 = abstractClientPlayerEntity.func_205015_b(f3);
        if (abstractClientPlayerEntity.func_184613_cA()) {
            super.func_225621_a_(abstractClientPlayerEntity, matrixStack, f, f2, f3);
            \u2603 = (float)abstractClientPlayerEntity.func_184599_cB() + f3;
            \u2603 = MathHelper.func_76131_a(\u2603 * \u2603 / 100.0f, 0.0f, 1.0f);
            if (!abstractClientPlayerEntity.func_204805_cN()) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(\u2603 * (-90.0f - abstractClientPlayerEntity.field_70125_A)));
            }
            Vector3d vector3d = abstractClientPlayerEntity.func_70676_i(f3);
            \u2603 = abstractClientPlayerEntity.func_213322_ci();
            double \u26032 = Entity.func_213296_b(\u2603);
            double \u26033 = Entity.func_213296_b(vector3d);
            if (\u26032 > 0.0 && \u26033 > 0.0) {
                double d = (\u2603.field_72450_a * vector3d.field_72450_a + \u2603.field_72449_c * vector3d.field_72449_c) / Math.sqrt(\u26032 * \u26033);
                \u2603 = \u2603.field_72450_a * vector3d.field_72449_c - \u2603.field_72449_c * vector3d.field_72450_a;
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(\u2603) * Math.acos(d))));
            }
        } else if (f4 > 0.0f) {
            super.func_225621_a_(abstractClientPlayerEntity, matrixStack, f, f2, f3);
            \u2603 = abstractClientPlayerEntity.func_70090_H() ? -90.0f - abstractClientPlayerEntity.field_70125_A : -90.0f;
            \u2603 = MathHelper.func_219799_g(f4, 0.0f, \u2603);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(\u2603));
            if (abstractClientPlayerEntity.func_213314_bj()) {
                matrixStack.func_227861_a_(0.0, -1.0, 0.3f);
            }
        } else {
            super.func_225621_a_(abstractClientPlayerEntity, matrixStack, f, f2, f3);
        }
    }
}

