/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.AreaEffectCloudRenderer;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.BatRenderer;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.client.renderer.entity.BlazeRenderer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.CaveSpiderRenderer;
import net.minecraft.client.renderer.entity.ChestedHorseRenderer;
import net.minecraft.client.renderer.entity.ChickenRenderer;
import net.minecraft.client.renderer.entity.CodRenderer;
import net.minecraft.client.renderer.entity.CowRenderer;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.DolphinRenderer;
import net.minecraft.client.renderer.entity.DragonFireballRenderer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.ElderGuardianRenderer;
import net.minecraft.client.renderer.entity.EnderCrystalRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EndermiteRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EvokerFangsRenderer;
import net.minecraft.client.renderer.entity.EvokerRenderer;
import net.minecraft.client.renderer.entity.ExperienceOrbRenderer;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.client.renderer.entity.FireworkRocketRenderer;
import net.minecraft.client.renderer.entity.FishRenderer;
import net.minecraft.client.renderer.entity.FoxRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.GiantZombieRenderer;
import net.minecraft.client.renderer.entity.GuardianRenderer;
import net.minecraft.client.renderer.entity.HoglinRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.HuskRenderer;
import net.minecraft.client.renderer.entity.IllusionerRenderer;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LeashKnotRenderer;
import net.minecraft.client.renderer.entity.LightningBoltRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.LlamaSpitRenderer;
import net.minecraft.client.renderer.entity.MagmaCubeRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.MooshroomRenderer;
import net.minecraft.client.renderer.entity.OcelotRenderer;
import net.minecraft.client.renderer.entity.PaintingRenderer;
import net.minecraft.client.renderer.entity.PandaRenderer;
import net.minecraft.client.renderer.entity.ParrotRenderer;
import net.minecraft.client.renderer.entity.PhantomRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.client.renderer.entity.PillagerRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.PolarBearRenderer;
import net.minecraft.client.renderer.entity.PufferfishRenderer;
import net.minecraft.client.renderer.entity.RabbitRenderer;
import net.minecraft.client.renderer.entity.RavagerRenderer;
import net.minecraft.client.renderer.entity.SalmonRenderer;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.ShulkerBulletRenderer;
import net.minecraft.client.renderer.entity.ShulkerRenderer;
import net.minecraft.client.renderer.entity.SilverfishRenderer;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.client.renderer.entity.SnowManRenderer;
import net.minecraft.client.renderer.entity.SpectralArrowRenderer;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.entity.SquidRenderer;
import net.minecraft.client.renderer.entity.StrayRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.TNTMinecartRenderer;
import net.minecraft.client.renderer.entity.TNTRenderer;
import net.minecraft.client.renderer.entity.TippedArrowRenderer;
import net.minecraft.client.renderer.entity.TridentRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.TurtleRenderer;
import net.minecraft.client.renderer.entity.UndeadHorseRenderer;
import net.minecraft.client.renderer.entity.VexRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.VindicatorRenderer;
import net.minecraft.client.renderer.entity.WanderingTraderRenderer;
import net.minecraft.client.renderer.entity.WitchRenderer;
import net.minecraft.client.renderer.entity.WitherRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.client.renderer.entity.WitherSkullRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.ZoglinRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityRendererManager {
    private static final RenderType field_229082_e_ = RenderType.func_239272_l_(new ResourceLocation("textures/misc/shadow.png"));
    private final Map<EntityType<?>, EntityRenderer<?>> field_78729_o = Maps.newHashMap();
    private final Map<String, PlayerRenderer> field_178636_l = Maps.newHashMap();
    private final PlayerRenderer field_178637_m;
    private final FontRenderer field_78736_p;
    public final TextureManager field_78724_e;
    private World field_78722_g;
    public ActiveRenderInfo field_217783_c;
    private Quaternion field_229083_k_;
    public Entity field_147941_i;
    public final GameSettings field_78733_k;
    private boolean field_178638_s = true;
    private boolean field_85095_o;

    public <E extends Entity> int func_229085_a_(E e, float f) {
        return this.func_78713_a(e).func_229100_c_(e, f);
    }

    private <T extends Entity> void func_229087_a_(EntityType<T> entityType, EntityRenderer<? super T> entityRenderer) {
        this.field_78729_o.put(entityType, entityRenderer);
    }

    private void func_229097_a_(net.minecraft.client.renderer.ItemRenderer itemRenderer, IReloadableResourceManager iReloadableResourceManager) {
        this.func_229087_a_(EntityType.field_200788_b, new AreaEffectCloudRenderer(this));
        this.func_229087_a_(EntityType.field_200789_c, new ArmorStandRenderer(this));
        this.func_229087_a_(EntityType.field_200790_d, new TippedArrowRenderer(this));
        this.func_229087_a_(EntityType.field_200791_e, new BatRenderer(this));
        this.func_229087_a_(EntityType.field_226289_e_, new BeeRenderer(this));
        this.func_229087_a_(EntityType.field_200792_f, new BlazeRenderer(this));
        this.func_229087_a_(EntityType.field_200793_g, new BoatRenderer(this));
        this.func_229087_a_(EntityType.field_220360_g, new CatRenderer(this));
        this.func_229087_a_(EntityType.field_200794_h, new CaveSpiderRenderer(this));
        this.func_229087_a_(EntityType.field_200773_M, new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200795_i, new ChickenRenderer(this));
        this.func_229087_a_(EntityType.field_203780_j, new CodRenderer(this));
        this.func_229087_a_(EntityType.field_200774_N, new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200796_j, new CowRenderer(this));
        this.func_229087_a_(EntityType.field_200797_k, new CreeperRenderer(this));
        this.func_229087_a_(EntityType.field_205137_n, new DolphinRenderer(this));
        this.func_229087_a_(EntityType.field_200798_l, new ChestedHorseRenderer(this, 0.87f));
        this.func_229087_a_(EntityType.field_200799_m, new DragonFireballRenderer(this));
        this.func_229087_a_(EntityType.field_204724_o, new DrownedRenderer(this));
        this.func_229087_a_(EntityType.field_200751_aq, new SpriteRenderer(this, itemRenderer));
        this.func_229087_a_(EntityType.field_200800_n, new ElderGuardianRenderer(this));
        this.func_229087_a_(EntityType.field_200801_o, new EnderCrystalRenderer(this));
        this.func_229087_a_(EntityType.field_200802_p, new EnderDragonRenderer(this));
        this.func_229087_a_(EntityType.field_200803_q, new EndermanRenderer(this));
        this.func_229087_a_(EntityType.field_200804_r, new EndermiteRenderer(this));
        this.func_229087_a_(EntityType.field_200752_ar, new SpriteRenderer(this, itemRenderer));
        this.func_229087_a_(EntityType.field_200805_s, new EvokerFangsRenderer(this));
        this.func_229087_a_(EntityType.field_200806_t, new EvokerRenderer(this));
        this.func_229087_a_(EntityType.field_200753_as, new SpriteRenderer(this, itemRenderer));
        this.func_229087_a_(EntityType.field_200807_u, new ExperienceOrbRenderer(this));
        this.func_229087_a_(EntityType.field_200808_v, new SpriteRenderer(this, itemRenderer, 1.0f, true));
        this.func_229087_a_(EntityType.field_200809_w, new FallingBlockRenderer(this));
        this.func_229087_a_(EntityType.field_200767_G, new SpriteRenderer(this, itemRenderer, 3.0f, true));
        this.func_229087_a_(EntityType.field_200810_x, new FireworkRocketRenderer(this, itemRenderer));
        this.func_229087_a_(EntityType.field_200730_aI, new FishRenderer(this));
        this.func_229087_a_(EntityType.field_220356_B, new FoxRenderer(this));
        this.func_229087_a_(EntityType.field_200775_O, new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200811_y, new GhastRenderer(this));
        this.func_229087_a_(EntityType.field_200812_z, new GiantZombieRenderer(this, 6.0f));
        this.func_229087_a_(EntityType.field_200761_A, new GuardianRenderer(this));
        this.func_229087_a_(EntityType.field_233588_G_, new HoglinRenderer(this));
        this.func_229087_a_(EntityType.field_200776_P, new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200762_B, new HorseRenderer(this));
        this.func_229087_a_(EntityType.field_200763_C, new HuskRenderer(this));
        this.func_229087_a_(EntityType.field_200764_D, new IllusionerRenderer(this));
        this.func_229087_a_(EntityType.field_200757_aw, new IronGolemRenderer(this));
        this.func_229087_a_(EntityType.field_200765_E, new ItemRenderer(this, itemRenderer));
        this.func_229087_a_(EntityType.field_200766_F, new ItemFrameRenderer(this, itemRenderer));
        this.func_229087_a_(EntityType.field_200768_H, new LeashKnotRenderer(this));
        this.func_229087_a_(EntityType.field_200728_aG, new LightningBoltRenderer(this));
        this.func_229087_a_(EntityType.field_200769_I, new LlamaRenderer(this));
        this.func_229087_a_(EntityType.field_200770_J, new LlamaSpitRenderer(this));
        this.func_229087_a_(EntityType.field_200771_K, new MagmaCubeRenderer(this));
        this.func_229087_a_(EntityType.field_200772_L, new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200780_T, new MooshroomRenderer(this));
        this.func_229087_a_(EntityType.field_200779_S, new ChestedHorseRenderer(this, 0.92f));
        this.func_229087_a_(EntityType.field_200781_U, new OcelotRenderer(this));
        this.func_229087_a_(EntityType.field_200782_V, new PaintingRenderer(this));
        this.func_229087_a_(EntityType.field_220353_aa, new PandaRenderer(this));
        this.func_229087_a_(EntityType.field_200783_W, new ParrotRenderer(this));
        this.func_229087_a_(EntityType.field_203097_aH, new PhantomRenderer(this));
        this.func_229087_a_(EntityType.field_200784_X, new PigRenderer(this));
        this.func_229087_a_(EntityType.field_233591_ai_, new PiglinRenderer(this, false));
        this.func_229087_a_(EntityType.field_242287_aj, new PiglinRenderer(this, false));
        this.func_229087_a_(EntityType.field_220350_aJ, new PillagerRenderer(this));
        this.func_229087_a_(EntityType.field_200786_Z, new PolarBearRenderer(this));
        this.func_229087_a_(EntityType.field_200754_at, new SpriteRenderer(this, itemRenderer));
        this.func_229087_a_(EntityType.field_203779_Z, new PufferfishRenderer(this));
        this.func_229087_a_(EntityType.field_200736_ab, new RabbitRenderer(this));
        this.func_229087_a_(EntityType.field_220352_aU, new RavagerRenderer(this));
        this.func_229087_a_(EntityType.field_203778_ae, new SalmonRenderer(this));
        this.func_229087_a_(EntityType.field_200737_ac, new SheepRenderer(this));
        this.func_229087_a_(EntityType.field_200739_ae, new ShulkerBulletRenderer(this));
        this.func_229087_a_(EntityType.field_200738_ad, new ShulkerRenderer(this));
        this.func_229087_a_(EntityType.field_200740_af, new SilverfishRenderer(this));
        this.func_229087_a_(EntityType.field_200742_ah, new UndeadHorseRenderer(this));
        this.func_229087_a_(EntityType.field_200741_ag, new SkeletonRenderer(this));
        this.func_229087_a_(EntityType.field_200743_ai, new SlimeRenderer(this));
        this.func_229087_a_(EntityType.field_200744_aj, new SpriteRenderer(this, itemRenderer, 0.75f, true));
        this.func_229087_a_(EntityType.field_200746_al, new SpriteRenderer(this, itemRenderer));
        this.func_229087_a_(EntityType.field_200745_ak, new SnowManRenderer(this));
        this.func_229087_a_(EntityType.field_200777_Q, new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200747_am, new SpectralArrowRenderer(this));
        this.func_229087_a_(EntityType.field_200748_an, new SpiderRenderer(this));
        this.func_229087_a_(EntityType.field_200749_ao, new SquidRenderer(this));
        this.func_229087_a_(EntityType.field_200750_ap, new StrayRenderer(this));
        this.func_229087_a_(EntityType.field_200778_R, new TNTMinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200735_aa, new TNTRenderer(this));
        this.func_229087_a_(EntityType.field_220354_ax, new LlamaRenderer(this));
        this.func_229087_a_(EntityType.field_203098_aL, new TridentRenderer(this));
        this.func_229087_a_(EntityType.field_204262_at, new TropicalFishRenderer(this));
        this.func_229087_a_(EntityType.field_203099_aq, new TurtleRenderer(this));
        this.func_229087_a_(EntityType.field_200755_au, new VexRenderer(this));
        this.func_229087_a_(EntityType.field_200756_av, new VillagerRenderer(this, iReloadableResourceManager));
        this.func_229087_a_(EntityType.field_200758_ax, new VindicatorRenderer(this));
        this.func_229087_a_(EntityType.field_220351_aK, new WanderingTraderRenderer(this));
        this.func_229087_a_(EntityType.field_200759_ay, new WitchRenderer(this));
        this.func_229087_a_(EntityType.field_200760_az, new WitherRenderer(this));
        this.func_229087_a_(EntityType.field_200722_aA, new WitherSkeletonRenderer(this));
        this.func_229087_a_(EntityType.field_200723_aB, new WitherSkullRenderer(this));
        this.func_229087_a_(EntityType.field_200724_aC, new WolfRenderer(this));
        this.func_229087_a_(EntityType.field_233590_aW_, new ZoglinRenderer(this));
        this.func_229087_a_(EntityType.field_200726_aE, new UndeadHorseRenderer(this));
        this.func_229087_a_(EntityType.field_200725_aD, new ZombieRenderer(this));
        this.func_229087_a_(EntityType.field_233592_ba_, new PiglinRenderer(this, true));
        this.func_229087_a_(EntityType.field_200727_aF, new ZombieVillagerRenderer(this, iReloadableResourceManager));
        this.func_229087_a_(EntityType.field_233589_aE_, new StriderRenderer(this));
    }

    public EntityRendererManager(TextureManager textureManager, net.minecraft.client.renderer.ItemRenderer itemRenderer, IReloadableResourceManager iReloadableResourceManager, FontRenderer fontRenderer, GameSettings gameSettings) {
        this.field_78724_e = textureManager;
        this.field_78736_p = fontRenderer;
        this.field_78733_k = gameSettings;
        this.func_229097_a_(itemRenderer, iReloadableResourceManager);
        this.field_178637_m = new PlayerRenderer(this);
        this.field_178636_l.put("default", this.field_178637_m);
        this.field_178636_l.put("slim", new PlayerRenderer(this, true));
        for (EntityType entityType : Registry.field_212629_r) {
            if (entityType == EntityType.field_200729_aH || this.field_78729_o.containsKey(entityType)) continue;
            throw new IllegalStateException("No renderer registered for " + Registry.field_212629_r.func_177774_c(entityType));
        }
    }

    public <T extends Entity> EntityRenderer<? super T> func_78713_a(T t) {
        if (t instanceof AbstractClientPlayerEntity) {
            String string = ((AbstractClientPlayerEntity)t).func_175154_l();
            PlayerRenderer \u26032 = this.field_178636_l.get(string);
            if (\u26032 != null) {
                return \u26032;
            }
            return this.field_178637_m;
        }
        return this.field_78729_o.get(t.func_200600_R());
    }

    public void func_229088_a_(World world, ActiveRenderInfo activeRenderInfo, Entity entity) {
        this.field_78722_g = world;
        this.field_217783_c = activeRenderInfo;
        this.field_229083_k_ = activeRenderInfo.func_227995_f_();
        this.field_147941_i = entity;
    }

    public void func_229089_a_(Quaternion quaternion) {
        this.field_229083_k_ = quaternion;
    }

    public void func_178633_a(boolean bl) {
        this.field_178638_s = bl;
    }

    public void func_178629_b(boolean bl) {
        this.field_85095_o = bl;
    }

    public boolean func_178634_b() {
        return this.field_85095_o;
    }

    public <E extends Entity> boolean func_229086_a_(E e, ClippingHelper clippingHelper, double d, double d2, double d3) {
        EntityRenderer<E> entityRenderer = this.func_78713_a(e);
        return entityRenderer.func_225626_a_(e, clippingHelper, d, d2, d3);
    }

    public <E extends Entity> void func_229084_a_(E e, double d, double d2, double d3, float f, float f2, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n) {
        EntityRenderer<E> entityRenderer = this.func_78713_a(e);
        try {
            Vector3d vector3d = entityRenderer.func_225627_b_(e, f2);
            double \u26032 = d + vector3d.func_82615_a();
            double \u26033 = d2 + vector3d.func_82617_b();
            double \u26034 = d3 + vector3d.func_82616_c();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(\u26032, \u26033, \u26034);
            entityRenderer.func_225623_a_(e, f, f2, matrixStack, iRenderTypeBuffer, n);
            if (e.func_90999_ad()) {
                this.func_229095_a_(matrixStack, iRenderTypeBuffer, e);
            }
            matrixStack.func_227861_a_(-vector3d.func_82615_a(), -vector3d.func_82617_b(), -vector3d.func_82616_c());
            if (this.field_78733_k.field_181151_V && this.field_178638_s && entityRenderer.field_76989_e > 0.0f && !e.func_82150_aj() && (\u2603 = (float)((1.0 - (\u2603 = this.func_78714_a(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_())) / 256.0) * (double)entityRenderer.field_76987_f)) > 0.0f) {
                EntityRendererManager.func_229096_a_(matrixStack, iRenderTypeBuffer, e, \u2603, f2, this.field_78722_g, entityRenderer.field_76989_e);
            }
            if (this.field_85095_o && !e.func_82150_aj() && !Minecraft.func_71410_x().func_189648_am()) {
                this.func_229093_a_(matrixStack, iRenderTypeBuffer.getBuffer(RenderType.func_228659_m_()), e, f2);
            }
            matrixStack.func_227865_b_();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering entity in world");
            CrashReportCategory \u26035 = crashReport.func_85058_a("Entity being rendered");
            e.func_85029_a(\u26035);
            CrashReportCategory \u26036 = crashReport.func_85058_a("Renderer details");
            \u26036.func_71507_a("Assigned renderer", entityRenderer);
            \u26036.func_71507_a("Location", CrashReportCategory.func_85074_a(d, d2, d3));
            \u26036.func_71507_a("Rotation", Float.valueOf(f));
            \u26036.func_71507_a("Delta", Float.valueOf(f2));
            throw new ReportedException(crashReport);
        }
    }

    private void func_229093_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, Entity entity2, float f) {
        Entity entity2;
        \u2603 = entity2.func_213311_cf() / 2.0f;
        this.func_229094_a_(matrixStack, iVertexBuilder, entity2, 1.0f, 1.0f, 1.0f);
        if (entity2 instanceof EnderDragonEntity) {
            double d = -MathHelper.func_219803_d(f, entity2.field_70142_S, entity2.func_226277_ct_());
            \u2603 = -MathHelper.func_219803_d(f, entity2.field_70137_T, entity2.func_226278_cu_());
            \u2603 = -MathHelper.func_219803_d(f, entity2.field_70136_U, entity2.func_226281_cx_());
            for (EnderDragonPartEntity enderDragonPartEntity : ((EnderDragonEntity)entity2).func_213404_dT()) {
                matrixStack.func_227860_a_();
                double d2 = d + MathHelper.func_219803_d(f, enderDragonPartEntity.field_70142_S, enderDragonPartEntity.func_226277_ct_());
                \u2603 = \u2603 + MathHelper.func_219803_d(f, enderDragonPartEntity.field_70137_T, enderDragonPartEntity.func_226278_cu_());
                \u2603 = \u2603 + MathHelper.func_219803_d(f, enderDragonPartEntity.field_70136_U, enderDragonPartEntity.func_226281_cx_());
                matrixStack.func_227861_a_(d2, \u2603, \u2603);
                this.func_229094_a_(matrixStack, iVertexBuilder, enderDragonPartEntity, 0.25f, 1.0f, 0.0f);
                matrixStack.func_227865_b_();
            }
        }
        if (entity2 instanceof LivingEntity) {
            float f2 = 0.01f;
            WorldRenderer.func_228427_a_(matrixStack, iVertexBuilder, -\u2603, entity2.func_70047_e() - 0.01f, -\u2603, \u2603, entity2.func_70047_e() + 0.01f, \u2603, 1.0f, 0.0f, 0.0f, 1.0f);
        }
        Vector3d \u26032 = entity2.func_70676_i(f);
        Matrix4f \u26033 = matrixStack.func_227866_c_().func_227870_a_();
        iVertexBuilder.func_227888_a_(\u26033, 0.0f, entity2.func_70047_e(), 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
        iVertexBuilder.func_227888_a_(\u26033, (float)(\u26032.field_72450_a * 2.0), (float)((double)entity2.func_70047_e() + \u26032.field_72448_b * 2.0), (float)(\u26032.field_72449_c * 2.0)).func_225586_a_(0, 0, 255, 255).func_181675_d();
    }

    private void func_229094_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, Entity entity, float f, float f2, float f3) {
        AxisAlignedBB axisAlignedBB = entity.func_174813_aQ().func_72317_d(-entity.func_226277_ct_(), -entity.func_226278_cu_(), -entity.func_226281_cx_());
        WorldRenderer.func_228430_a_(matrixStack, iVertexBuilder, axisAlignedBB, f, f2, f3, 1.0f);
    }

    private void func_229095_a_(MatrixStack matrixStack2, IRenderTypeBuffer iRenderTypeBuffer, Entity entity) {
        MatrixStack matrixStack2;
        TextureAtlasSprite textureAtlasSprite = ModelBakery.field_207763_a.func_229314_c_();
        \u2603 = ModelBakery.field_207764_b.func_229314_c_();
        matrixStack2.func_227860_a_();
        float \u26032 = entity.func_213311_cf() * 1.4f;
        matrixStack2.func_227862_a_(\u26032, \u26032, \u26032);
        float \u26033 = 0.5f;
        float \u26034 = 0.0f;
        float \u26035 = entity.func_213302_cg() / \u26032;
        float \u26036 = 0.0f;
        matrixStack2.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-this.field_217783_c.func_216778_f()));
        matrixStack2.func_227861_a_(0.0, 0.0, -0.3f + (float)((int)\u26035) * 0.02f);
        float \u26037 = 0.0f;
        int \u26038 = 0;
        IVertexBuilder \u26039 = iRenderTypeBuffer.getBuffer(Atlases.func_228783_h_());
        MatrixStack.Entry \u260310 = matrixStack2.func_227866_c_();
        while (\u26035 > 0.0f) {
            \u2603 = \u26038 % 2 == 0 ? textureAtlasSprite : \u2603;
            float f = \u2603.func_94209_e();
            \u2603 = \u2603.func_94206_g();
            \u2603 = \u2603.func_94212_f();
            \u2603 = \u2603.func_94210_h();
            if (\u26038 / 2 % 2 == 0) {
                \u2603 = \u2603;
                \u2603 = f;
                f = \u2603;
            }
            EntityRendererManager.func_229090_a_(\u260310, \u26039, \u26033 - 0.0f, 0.0f - \u26036, \u26037, \u2603, \u2603);
            EntityRendererManager.func_229090_a_(\u260310, \u26039, -\u26033 - 0.0f, 0.0f - \u26036, \u26037, f, \u2603);
            EntityRendererManager.func_229090_a_(\u260310, \u26039, -\u26033 - 0.0f, 1.4f - \u26036, \u26037, f, \u2603);
            EntityRendererManager.func_229090_a_(\u260310, \u26039, \u26033 - 0.0f, 1.4f - \u26036, \u26037, \u2603, \u2603);
            \u26035 -= 0.45f;
            \u26036 -= 0.45f;
            \u26033 *= 0.9f;
            \u26037 += 0.03f;
            ++\u26038;
        }
        matrixStack2.func_227865_b_();
    }

    private static void func_229090_a_(MatrixStack.Entry entry, IVertexBuilder iVertexBuilder, float f, float f2, float f3, float f4, float f5) {
        iVertexBuilder.func_227888_a_(entry.func_227870_a_(), f, f2, f3).func_225586_a_(255, 255, 255, 255).func_225583_a_(f4, f5).func_225585_a_(0, 10).func_227886_a_(240).func_227887_a_(entry.func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static void func_229096_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, Entity entity, float f, float f2, IWorldReader iWorldReader, float f3) {
        \u2603 = f3;
        if (entity instanceof MobEntity && (\u2603 = (MobEntity)entity).func_70631_g_()) {
            \u2603 *= 0.5f;
        }
        double d = MathHelper.func_219803_d(f2, entity.field_70142_S, entity.func_226277_ct_());
        \u2603 = MathHelper.func_219803_d(f2, entity.field_70137_T, entity.func_226278_cu_());
        \u2603 = MathHelper.func_219803_d(f2, entity.field_70136_U, entity.func_226281_cx_());
        int \u26032 = MathHelper.func_76128_c(d - (double)\u2603);
        int \u26033 = MathHelper.func_76128_c(d + (double)\u2603);
        int \u26034 = MathHelper.func_76128_c(\u2603 - (double)\u2603);
        int \u26035 = MathHelper.func_76128_c(\u2603);
        int \u26036 = MathHelper.func_76128_c(\u2603 - (double)\u2603);
        int \u26037 = MathHelper.func_76128_c(\u2603 + (double)\u2603);
        MatrixStack.Entry \u26038 = matrixStack.func_227866_c_();
        IVertexBuilder \u26039 = iRenderTypeBuffer.getBuffer(field_229082_e_);
        for (BlockPos blockPos : BlockPos.func_218278_a(new BlockPos(\u26032, \u26034, \u26036), new BlockPos(\u26033, \u26035, \u26037))) {
            EntityRendererManager.func_229092_a_(\u26038, \u26039, iWorldReader, blockPos, d, \u2603, \u2603, \u2603, f);
        }
    }

    private static void func_229092_a_(MatrixStack.Entry entry, IVertexBuilder iVertexBuilder, IWorldReader iWorldReader, BlockPos blockPos, double d, double d2, double d3, float f, float f2) {
        BlockPos blockPos2 = blockPos.func_177977_b();
        BlockState \u26032 = iWorldReader.func_180495_p(blockPos2);
        if (\u26032.func_185901_i() == BlockRenderType.INVISIBLE || iWorldReader.func_201696_r(blockPos) <= 3) {
            return;
        }
        if (!\u26032.func_235785_r_(iWorldReader, blockPos2)) {
            return;
        }
        VoxelShape \u26033 = \u26032.func_196954_c(iWorldReader, blockPos.func_177977_b());
        if (\u26033.func_197766_b()) {
            return;
        }
        float \u26034 = (float)(((double)f2 - (d2 - (double)blockPos.func_177956_o()) / 2.0) * 0.5 * (double)iWorldReader.func_205052_D(blockPos));
        if (\u26034 >= 0.0f) {
            if (\u26034 > 1.0f) {
                \u26034 = 1.0f;
            }
            AxisAlignedBB axisAlignedBB = \u26033.func_197752_a();
            double \u26035 = (double)blockPos.func_177958_n() + axisAlignedBB.field_72340_a;
            double \u26036 = (double)blockPos.func_177958_n() + axisAlignedBB.field_72336_d;
            double \u26037 = (double)blockPos.func_177956_o() + axisAlignedBB.field_72338_b;
            double \u26038 = (double)blockPos.func_177952_p() + axisAlignedBB.field_72339_c;
            double \u26039 = (double)blockPos.func_177952_p() + axisAlignedBB.field_72334_f;
            float \u260310 = (float)(\u26035 - d);
            float \u260311 = (float)(\u26036 - d);
            float \u260312 = (float)(\u26037 - d2);
            float \u260313 = (float)(\u26038 - d3);
            float \u260314 = (float)(\u26039 - d3);
            float \u260315 = -\u260310 / 2.0f / f + 0.5f;
            float \u260316 = -\u260311 / 2.0f / f + 0.5f;
            float \u260317 = -\u260313 / 2.0f / f + 0.5f;
            float \u260318 = -\u260314 / 2.0f / f + 0.5f;
            EntityRendererManager.func_229091_a_(entry, iVertexBuilder, \u26034, \u260310, \u260312, \u260313, \u260315, \u260317);
            EntityRendererManager.func_229091_a_(entry, iVertexBuilder, \u26034, \u260310, \u260312, \u260314, \u260315, \u260318);
            EntityRendererManager.func_229091_a_(entry, iVertexBuilder, \u26034, \u260311, \u260312, \u260314, \u260316, \u260318);
            EntityRendererManager.func_229091_a_(entry, iVertexBuilder, \u26034, \u260311, \u260312, \u260313, \u260316, \u260317);
        }
    }

    private static void func_229091_a_(MatrixStack.Entry entry, IVertexBuilder iVertexBuilder, float f, float f2, float f3, float f4, float f5, float f6) {
        iVertexBuilder.func_227888_a_(entry.func_227870_a_(), f2, f3, f4).func_227885_a_(1.0f, 1.0f, 1.0f, f).func_225583_a_(f5, f6).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(entry.func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public void func_78717_a(@Nullable World world) {
        this.field_78722_g = world;
        if (world == null) {
            this.field_217783_c = null;
        }
    }

    public double func_229099_b_(Entity entity) {
        return this.field_217783_c.func_216785_c().func_72436_e(entity.func_213303_ch());
    }

    public double func_78714_a(double d, double d2, double d3) {
        return this.field_217783_c.func_216785_c().func_186679_c(d, d2, d3);
    }

    public Quaternion func_229098_b_() {
        return this.field_229083_k_;
    }

    public FontRenderer func_78716_a() {
        return this.field_78736_p;
    }
}

