/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.blaze3d.vertex.DefaultColorVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexConsumer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferBuilder
extends DefaultColorVertexBuilder
implements IVertexConsumer {
    private static final Logger field_187316_a = LogManager.getLogger();
    private ByteBuffer field_179001_a;
    private final List<DrawState> field_227821_i_ = Lists.newArrayList();
    private int field_227822_j_ = 0;
    private int field_227823_k_ = 0;
    private int field_227824_l_ = 0;
    private int field_227825_m_ = 0;
    private int field_178997_d;
    @Nullable
    private VertexFormatElement field_181677_f;
    private int field_181678_g;
    private int field_179006_k;
    private VertexFormat field_179011_q;
    private boolean field_227826_s_;
    private boolean field_227827_t_;
    private boolean field_179010_r;

    public BufferBuilder(int n) {
        this.field_179001_a = GLAllocation.func_74524_c(n * 4);
    }

    protected void func_227831_b_() {
        this.func_181670_b(this.field_179011_q.func_177338_f());
    }

    private void func_181670_b(int n) {
        if (this.field_227824_l_ + n <= this.field_179001_a.capacity()) {
            return;
        }
        \u2603 = this.field_179001_a.capacity();
        \u2603 = \u2603 + BufferBuilder.func_216566_c(n);
        field_187316_a.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)\u2603, (Object)\u2603);
        ByteBuffer byteBuffer = GLAllocation.func_74524_c(\u2603);
        this.field_179001_a.position(0);
        byteBuffer.put(this.field_179001_a);
        byteBuffer.rewind();
        this.field_179001_a = byteBuffer;
    }

    private static int func_216566_c(int n) {
        \u2603 = 0x200000;
        if (n == 0) {
            return \u2603;
        }
        if (n < 0) {
            \u2603 *= -1;
        }
        if ((\u2603 = n % \u2603) == 0) {
            return n;
        }
        return n + \u2603 - \u2603;
    }

    public void func_181674_a(float f, float f2, float f3) {
        this.field_179001_a.clear();
        FloatBuffer floatBuffer = this.field_179001_a.asFloatBuffer();
        int \u26032 = this.field_178997_d / 4;
        float[] \u26033 = new float[\u26032];
        for (int i = 0; i < \u26032; ++i) {
            \u26033[i] = BufferBuilder.func_181665_a(floatBuffer, f, f2, f3, this.field_179011_q.func_181719_f(), this.field_227823_k_ / 4 + i * this.field_179011_q.func_177338_f());
        }
        int[] nArray = new int[\u26032];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        IntArrays.mergeSort((int[])nArray, (n, n2) -> Floats.compare((float)\u26033[n2], (float)\u26033[n]));
        BitSet \u26034 = new BitSet();
        FloatBuffer \u26035 = GLAllocation.func_74529_h(this.field_179011_q.func_181719_f() * 4);
        int \u26036 = \u26034.nextClearBit(0);
        while (\u26036 < nArray.length) {
            int n3 = nArray[\u26036];
            if (n3 != \u26036) {
                this.func_227829_a_(floatBuffer, n3);
                \u26035.clear();
                \u26035.put(floatBuffer);
                \u26037 = n3;
                \u26038 = nArray[\u26037];
                while (\u26037 != \u26036) {
                    this.func_227829_a_(floatBuffer, \u26038);
                    FloatBuffer floatBuffer2 = floatBuffer.slice();
                    this.func_227829_a_(floatBuffer, \u26037);
                    floatBuffer.put(floatBuffer2);
                    \u26034.set(\u26037);
                    int \u26037 = \u26038;
                    int \u26038 = nArray[\u26037];
                }
                this.func_227829_a_(floatBuffer, \u26036);
                \u26035.flip();
                floatBuffer.put(\u26035);
            }
            \u26034.set(\u26036);
            \u26036 = \u26034.nextClearBit(\u26036 + 1);
        }
    }

    private void func_227829_a_(FloatBuffer floatBuffer, int n) {
        \u2603 = this.field_179011_q.func_181719_f() * 4;
        floatBuffer.limit(this.field_227823_k_ / 4 + (n + 1) * \u2603);
        floatBuffer.position(this.field_227823_k_ / 4 + n * \u2603);
    }

    public State func_181672_a() {
        this.field_179001_a.limit(this.field_227824_l_);
        this.field_179001_a.position(this.field_227823_k_);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.field_178997_d * this.field_179011_q.func_177338_f());
        byteBuffer.put(this.field_179001_a);
        this.field_179001_a.clear();
        return new State(byteBuffer, this.field_179011_q);
    }

    private static float func_181665_a(FloatBuffer floatBuffer, float f, float f2, float f3, int n, int n2) {
        float f4 = floatBuffer.get(n2 + n * 0 + 0);
        \u2603 = floatBuffer.get(n2 + n * 0 + 1);
        \u2603 = floatBuffer.get(n2 + n * 0 + 2);
        \u2603 = floatBuffer.get(n2 + n * 1 + 0);
        \u2603 = floatBuffer.get(n2 + n * 1 + 1);
        \u2603 = floatBuffer.get(n2 + n * 1 + 2);
        \u2603 = floatBuffer.get(n2 + n * 2 + 0);
        \u2603 = floatBuffer.get(n2 + n * 2 + 1);
        \u2603 = floatBuffer.get(n2 + n * 2 + 2);
        \u2603 = floatBuffer.get(n2 + n * 3 + 0);
        \u2603 = floatBuffer.get(n2 + n * 3 + 1);
        \u2603 = floatBuffer.get(n2 + n * 3 + 2);
        \u2603 = (f4 + \u2603 + \u2603 + \u2603) * 0.25f - f;
        \u2603 = (\u2603 + \u2603 + \u2603 + \u2603) * 0.25f - f2;
        \u2603 = (\u2603 + \u2603 + \u2603 + \u2603) * 0.25f - f3;
        return \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
    }

    public void func_178993_a(State state) {
        state.field_227841_a_.clear();
        int n = state.field_227841_a_.capacity();
        this.func_181670_b(n);
        this.field_179001_a.limit(this.field_179001_a.capacity());
        this.field_179001_a.position(this.field_227823_k_);
        this.field_179001_a.put(state.field_227841_a_);
        this.field_179001_a.clear();
        VertexFormat \u26032 = state.field_179018_e;
        this.func_227828_a_(\u26032);
        this.field_178997_d = n / \u26032.func_177338_f();
        this.field_227824_l_ = this.field_227823_k_ + this.field_178997_d * \u26032.func_177338_f();
    }

    public void func_181668_a(int n, VertexFormat vertexFormat) {
        if (this.field_179010_r) {
            throw new IllegalStateException("Already building!");
        }
        this.field_179010_r = true;
        this.field_179006_k = n;
        this.func_227828_a_(vertexFormat);
        this.field_181677_f = (VertexFormatElement)vertexFormat.func_227894_c_().get(0);
        this.field_181678_g = 0;
        this.field_179001_a.clear();
    }

    private void func_227828_a_(VertexFormat vertexFormat) {
        if (this.field_179011_q == vertexFormat) {
            return;
        }
        this.field_179011_q = vertexFormat;
        boolean bl = vertexFormat == DefaultVertexFormats.field_227849_i_;
        \u2603 = vertexFormat == DefaultVertexFormats.field_176600_a;
        this.field_227826_s_ = bl || \u2603;
        this.field_227827_t_ = bl;
    }

    public void func_178977_d() {
        if (!this.field_179010_r) {
            throw new IllegalStateException("Not building!");
        }
        this.field_179010_r = false;
        this.field_227821_i_.add(new DrawState(this.field_179011_q, this.field_178997_d, this.field_179006_k));
        this.field_227823_k_ += this.field_178997_d * this.field_179011_q.func_177338_f();
        this.field_178997_d = 0;
        this.field_181677_f = null;
        this.field_181678_g = 0;
    }

    @Override
    public void func_225589_a_(int n, byte by) {
        this.field_179001_a.put(this.field_227824_l_ + n, by);
    }

    @Override
    public void func_225591_a_(int n, short s) {
        this.field_179001_a.putShort(this.field_227824_l_ + n, s);
    }

    @Override
    public void func_225590_a_(int n, float f) {
        this.field_179001_a.putFloat(this.field_227824_l_ + n, f);
    }

    @Override
    public void func_181675_d() {
        if (this.field_181678_g != 0) {
            throw new IllegalStateException("Not filled all elements of the vertex");
        }
        ++this.field_178997_d;
        this.func_227831_b_();
    }

    @Override
    public void func_181667_k() {
        ImmutableList<VertexFormatElement> immutableList = this.field_179011_q.func_227894_c_();
        this.field_181678_g = (this.field_181678_g + 1) % immutableList.size();
        this.field_227824_l_ += this.field_181677_f.func_177368_f();
        this.field_181677_f = \u2603 = (VertexFormatElement)immutableList.get(this.field_181678_g);
        if (\u2603.func_177375_c() == VertexFormatElement.Usage.PADDING) {
            this.func_181667_k();
        }
        if (this.field_227854_a_ && this.field_181677_f.func_177375_c() == VertexFormatElement.Usage.COLOR) {
            IVertexConsumer.super.func_225586_a_(this.field_227855_b_, this.field_227856_c_, this.field_227857_d_, this.field_227858_e_);
        }
    }

    @Override
    public IVertexBuilder func_225586_a_(int n, int n2, int n3, int n4) {
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        return IVertexConsumer.super.func_225586_a_(n, n2, n3, n4);
    }

    @Override
    public void func_225588_a_(float f13, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n, int n2, float f10, float f11, float f12) {
        float f13;
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        if (this.field_227826_s_) {
            int n3;
            this.func_225590_a_(0, f13);
            this.func_225590_a_(4, f2);
            this.func_225590_a_(8, f3);
            this.func_225589_a_(12, (byte)(f4 * 255.0f));
            this.func_225589_a_(13, (byte)(f5 * 255.0f));
            this.func_225589_a_(14, (byte)(f6 * 255.0f));
            this.func_225589_a_(15, (byte)(f7 * 255.0f));
            this.func_225590_a_(16, f8);
            this.func_225590_a_(20, f9);
            if (this.field_227827_t_) {
                this.func_225591_a_(24, (short)(n & 0xFFFF));
                this.func_225591_a_(26, (short)(n >> 16 & 0xFFFF));
                n3 = 28;
            } else {
                n3 = 24;
            }
            this.func_225591_a_(n3 + 0, (short)(n2 & 0xFFFF));
            this.func_225591_a_(n3 + 2, (short)(n2 >> 16 & 0xFFFF));
            this.func_225589_a_(n3 + 4, IVertexConsumer.func_227846_a_(f10));
            this.func_225589_a_(n3 + 5, IVertexConsumer.func_227846_a_(f11));
            this.func_225589_a_(n3 + 6, IVertexConsumer.func_227846_a_(f12));
            this.field_227824_l_ += n3 + 8;
            this.func_181675_d();
            return;
        }
        super.func_225588_a_(f13, f2, f3, f4, f5, f6, f7, f8, f9, n, n2, f10, f11, f12);
    }

    public Pair<DrawState, ByteBuffer> func_227832_f_() {
        DrawState drawState = this.field_227821_i_.get(this.field_227822_j_++);
        this.field_179001_a.position(this.field_227825_m_);
        this.field_227825_m_ += drawState.func_227839_b_() * drawState.func_227838_a_().func_177338_f();
        this.field_179001_a.limit(this.field_227825_m_);
        if (this.field_227822_j_ == this.field_227821_i_.size() && this.field_178997_d == 0) {
            this.func_178965_a();
        }
        ByteBuffer \u26032 = this.field_179001_a.slice();
        this.field_179001_a.clear();
        return Pair.of((Object)drawState, (Object)\u26032);
    }

    public void func_178965_a() {
        if (this.field_227823_k_ != this.field_227825_m_) {
            field_187316_a.warn("Bytes mismatch " + this.field_227823_k_ + " " + this.field_227825_m_);
        }
        this.func_227833_h_();
    }

    public void func_227833_h_() {
        this.field_227823_k_ = 0;
        this.field_227825_m_ = 0;
        this.field_227824_l_ = 0;
        this.field_227821_i_.clear();
        this.field_227822_j_ = 0;
    }

    @Override
    public VertexFormatElement func_225592_i_() {
        if (this.field_181677_f == null) {
            throw new IllegalStateException("BufferBuilder not started");
        }
        return this.field_181677_f;
    }

    public boolean func_227834_j_() {
        return this.field_179010_r;
    }

    public static final class DrawState {
        private final VertexFormat field_227835_a_;
        private final int field_227836_b_;
        private final int field_227837_c_;

        private DrawState(VertexFormat vertexFormat, int n, int n2) {
            this.field_227835_a_ = vertexFormat;
            this.field_227836_b_ = n;
            this.field_227837_c_ = n2;
        }

        public VertexFormat func_227838_a_() {
            return this.field_227835_a_;
        }

        public int func_227839_b_() {
            return this.field_227836_b_;
        }

        public int func_227840_c_() {
            return this.field_227837_c_;
        }
    }

    public static class State {
        private final ByteBuffer field_227841_a_;
        private final VertexFormat field_179018_e;

        private State(ByteBuffer byteBuffer, VertexFormat vertexFormat) {
            this.field_227841_a_ = byteBuffer;
            this.field_179018_e = vertexFormat;
        }
    }
}

