/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.Empty3i;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ScreenSize;
import net.minecraft.client.util.UndeclaredException;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Session;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Bootstrap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger field_199741_a = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Thread thread;
        Minecraft minecraft;
        OptionParser optionParser = new OptionParser();
        optionParser.allowsUnrecognizedOptions();
        optionParser.accepts("demo");
        optionParser.accepts("disableMultiplayer");
        optionParser.accepts("disableChat");
        optionParser.accepts("fullscreen");
        optionParser.accepts("checkGlErrors");
        ArgumentAcceptingOptionSpec \u26032 = optionParser.accepts("server").withRequiredArg();
        ArgumentAcceptingOptionSpec \u26033 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)25565, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u26034 = optionParser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec \u26035 = optionParser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec \u26036 = optionParser.accepts("resourcePackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec \u26037 = optionParser.accepts("dataPackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec \u26038 = optionParser.accepts("proxyHost").withRequiredArg();
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("proxyPort").withRequiredArg().defaultsTo((Object)"8080", (Object[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("proxyUser").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("proxyPass").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("username").withRequiredArg().defaultsTo((Object)("Player" + Util.func_211177_b() % 1000L), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("uuid").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260314 = optionParser.accepts("accessToken").withRequiredArg().required();
        ArgumentAcceptingOptionSpec \u260315 = optionParser.accepts("version").withRequiredArg().required();
        ArgumentAcceptingOptionSpec \u260316 = optionParser.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)854, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260317 = optionParser.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)480, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260318 = optionParser.accepts("fullscreenWidth").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec \u260319 = optionParser.accepts("fullscreenHeight").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec \u260320 = optionParser.accepts("userProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260321 = optionParser.accepts("profileProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260322 = optionParser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260323 = optionParser.accepts("userType").withRequiredArg().defaultsTo((Object)"legacy", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260324 = optionParser.accepts("versionType").withRequiredArg().defaultsTo((Object)"release", (Object[])new String[0]);
        NonOptionArgumentSpec \u260325 = optionParser.nonOptions();
        OptionSet \u260326 = optionParser.parse(stringArray);
        List \u260327 = \u260326.valuesOf((OptionSpec)\u260325);
        if (!\u260327.isEmpty()) {
            System.out.println("Completely ignored arguments: " + \u260327);
        }
        String \u260328 = (String)Main.func_206236_a(\u260326, \u26038);
        Proxy \u260329 = Proxy.NO_PROXY;
        if (\u260328 != null) {
            try {
                \u260329 = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(\u260328, (int)((Integer)Main.func_206236_a(\u260326, \u26039))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        final String \u260330 = (String)Main.func_206236_a(\u260326, \u260310);
        final String \u260331 = (String)Main.func_206236_a(\u260326, \u260311);
        if (!\u260329.equals(Proxy.NO_PROXY) && Main.func_110121_a(\u260330) && Main.func_110121_a(\u260331)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(\u260330, \u260331.toCharArray());
                }
            });
        }
        int \u260332 = (Integer)Main.func_206236_a(\u260326, \u260316);
        int \u260333 = (Integer)Main.func_206236_a(\u260326, \u260317);
        OptionalInt \u260334 = Main.func_224732_a((Integer)Main.func_206236_a(\u260326, \u260318));
        OptionalInt \u260335 = Main.func_224732_a((Integer)Main.func_206236_a(\u260326, \u260319));
        boolean \u260336 = \u260326.has("fullscreen");
        boolean \u260337 = \u260326.has("demo");
        boolean \u260338 = \u260326.has("disableMultiplayer");
        boolean \u260339 = \u260326.has("disableChat");
        String \u260340 = (String)Main.func_206236_a(\u260326, \u260315);
        Gson \u260341 = new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
        PropertyMap \u260342 = JSONUtils.func_188178_a(\u260341, (String)Main.func_206236_a(\u260326, \u260320), PropertyMap.class);
        PropertyMap \u260343 = JSONUtils.func_188178_a(\u260341, (String)Main.func_206236_a(\u260326, \u260321), PropertyMap.class);
        String \u260344 = (String)Main.func_206236_a(\u260326, \u260324);
        File \u260345 = (File)Main.func_206236_a(\u260326, \u26034);
        File \u260346 = \u260326.has((OptionSpec)\u26035) ? (File)Main.func_206236_a(\u260326, \u26035) : new File(\u260345, "assets/");
        File \u260347 = \u260326.has((OptionSpec)\u26036) ? (File)Main.func_206236_a(\u260326, \u26036) : new File(\u260345, "resourcepacks/");
        String \u260348 = \u260326.has((OptionSpec)\u260313) ? (String)\u260313.value(\u260326) : PlayerEntity.func_175147_b((String)\u260312.value(\u260326)).toString();
        String \u260349 = \u260326.has((OptionSpec)\u260322) ? (String)\u260322.value(\u260326) : null;
        String \u260350 = (String)Main.func_206236_a(\u260326, \u26032);
        Integer \u260351 = (Integer)Main.func_206236_a(\u260326, \u26033);
        CrashReport.func_230188_h_();
        Bootstrap.func_151354_b();
        Bootstrap.func_218821_c();
        Util.func_240994_l_();
        Session \u260352 = new Session((String)\u260312.value(\u260326), \u260348, (String)\u260314.value(\u260326), (String)\u260323.value(\u260326));
        GameConfiguration \u260353 = new GameConfiguration(new GameConfiguration.UserInformation(\u260352, \u260342, \u260343, \u260329), new ScreenSize(\u260332, \u260333, \u260334, \u260335, \u260336), new GameConfiguration.FolderInformation(\u260345, \u260347, \u260346, \u260349), new GameConfiguration.GameInformation(\u260337, \u260340, \u260344, \u260338, \u260339), new GameConfiguration.ServerInformation(\u260350, \u260351));
        Thread \u260354 = new Thread("Client Shutdown Thread"){

            @Override
            public void run() {
                Minecraft minecraft = Minecraft.func_71410_x();
                if (minecraft == null) {
                    return;
                }
                IntegratedServer \u26032 = minecraft.func_71401_C();
                if (\u26032 != null) {
                    \u26032.func_71263_m(true);
                }
            }
        };
        \u260354.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_199741_a));
        Runtime.getRuntime().addShutdownHook(\u260354);
        Empty3i \u260355 = new Empty3i();
        try {
            Thread.currentThread().setName("Render thread");
            RenderSystem.initRenderThread();
            RenderSystem.beginInitialization();
            minecraft = new Minecraft(\u260353);
            RenderSystem.finishInitialization();
        }
        catch (UndeclaredException undeclaredException) {
            field_199741_a.warn("Failed to create window: ", (Throwable)undeclaredException);
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Initializing game");
            crashReport.func_85058_a("Initialization");
            Minecraft.func_228009_a_(null, \u260353.field_178741_d.field_178755_b, null, crashReport);
            Minecraft.func_71377_b(crashReport);
            return;
        }
        if (minecraft.func_228017_as_()) {
            thread = new Thread("Game thread"){

                @Override
                public void run() {
                    try {
                        RenderSystem.initGameThread(true);
                        minecraft.func_99999_d();
                    }
                    catch (Throwable throwable) {
                        field_199741_a.error("Exception in client thread", throwable);
                    }
                }
            };
            thread.start();
            while (minecraft.func_228025_l_()) {
            }
        } else {
            thread = null;
            try {
                RenderSystem.initGameThread(false);
                minecraft.func_99999_d();
            }
            catch (Throwable \u260356) {
                field_199741_a.error("Unhandled game exception", \u260356);
            }
        }
        try {
            minecraft.func_71400_g();
            if (thread != null) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            field_199741_a.error("Exception during client thread shutdown", (Throwable)interruptedException);
        }
        finally {
            minecraft.func_71405_e();
        }
    }

    private static OptionalInt func_224732_a(@Nullable Integer n) {
        return n != null ? OptionalInt.of(n) : OptionalInt.empty();
    }

    @Nullable
    private static <T> T func_206236_a(OptionSet optionSet, OptionSpec<T> optionSpec) {
        try {
            return (T)optionSet.valueOf(optionSpec);
        }
        catch (Throwable throwable) {
            if (optionSpec instanceof ArgumentAcceptingOptionSpec && !(\u2603 = (\u2603 = (ArgumentAcceptingOptionSpec)optionSpec).defaultValues()).isEmpty()) {
                return (T)\u2603.get(0);
            }
            throw throwable;
        }
    }

    private static boolean func_110121_a(@Nullable String string) {
        return string != null && !string.isEmpty();
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

