/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.fonts.providers;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.fonts.IGlyphInfo;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.gui.fonts.providers.IGlyphProviderFactory;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureGlyphProvider
implements IGlyphProvider {
    private static final Logger field_211609_a = LogManager.getLogger();
    private final NativeImage field_211610_b;
    private final Int2ObjectMap<GlyphInfo> field_211267_a;

    private TextureGlyphProvider(NativeImage nativeImage, Int2ObjectMap<GlyphInfo> int2ObjectMap) {
        this.field_211610_b = nativeImage;
        this.field_211267_a = int2ObjectMap;
    }

    @Override
    public void close() {
        this.field_211610_b.close();
    }

    @Override
    @Nullable
    public IGlyphInfo func_212248_a(int n) {
        return (IGlyphInfo)this.field_211267_a.get(n);
    }

    @Override
    public IntSet func_230428_a_() {
        return IntSets.unmodifiable((IntSet)this.field_211267_a.keySet());
    }

    static final class GlyphInfo
    implements IGlyphInfo {
        private final float field_211582_a;
        private final NativeImage field_211583_b;
        private final int field_211584_c;
        private final int field_211585_d;
        private final int field_211586_e;
        private final int field_211587_f;
        private final int field_211588_g;
        private final int field_211589_h;

        private GlyphInfo(float f, NativeImage nativeImage, int n, int n2, int n3, int n4, int n5, int n6) {
            this.field_211582_a = f;
            this.field_211583_b = nativeImage;
            this.field_211584_c = n;
            this.field_211585_d = n2;
            this.field_211586_e = n3;
            this.field_211587_f = n4;
            this.field_211588_g = n5;
            this.field_211589_h = n6;
        }

        @Override
        public float func_211578_g() {
            return 1.0f / this.field_211582_a;
        }

        @Override
        public int func_211202_a() {
            return this.field_211586_e;
        }

        @Override
        public int func_211203_b() {
            return this.field_211587_f;
        }

        @Override
        public float getAdvance() {
            return this.field_211588_g;
        }

        @Override
        public float func_223277_l_() {
            return IGlyphInfo.super.func_223277_l_() + 7.0f - (float)this.field_211589_h;
        }

        @Override
        public void func_211573_a(int n, int n2) {
            this.field_211583_b.func_227788_a_(0, n, n2, this.field_211584_c, this.field_211585_d, this.field_211586_e, this.field_211587_f, false, false);
        }

        @Override
        public boolean func_211579_f() {
            return this.field_211583_b.func_211678_c().func_211651_a() > 1;
        }
    }

    public static class Factory
    implements IGlyphProviderFactory {
        private final ResourceLocation field_211252_a;
        private final List<int[]> field_211634_b;
        private final int field_211635_c;
        private final int field_211636_d;

        public Factory(ResourceLocation resourceLocation, int n, int n2, List<int[]> list) {
            this.field_211252_a = new ResourceLocation(resourceLocation.func_110624_b(), "textures/" + resourceLocation.func_110623_a());
            this.field_211634_b = list;
            this.field_211635_c = n;
            this.field_211636_d = n2;
        }

        public static Factory func_211633_a(JsonObject jsonObject) {
            int n = JSONUtils.func_151208_a(jsonObject, "height", 8);
            \u2603 = JSONUtils.func_151203_m(jsonObject, "ascent");
            if (\u2603 > n) {
                throw new JsonParseException("Ascent " + \u2603 + " higher than height " + n);
            }
            ArrayList \u26032 = Lists.newArrayList();
            JsonArray \u26033 = JSONUtils.func_151214_t(jsonObject, "chars");
            for (\u2603 = 0; \u2603 < \u26033.size(); ++\u2603) {
                String string = JSONUtils.func_151206_a(\u26033.get(\u2603), "chars[" + \u2603 + "]");
                int[] \u26034 = string.codePoints().toArray();
                if (\u2603 > 0 && \u26034.length != (\u2603 = ((int[])\u26032.get(0)).length)) {
                    throw new JsonParseException("Elements of chars have to be the same length (found: " + \u26034.length + ", expected: " + \u2603 + "), pad with space or \\u0000");
                }
                \u26032.add(\u26034);
            }
            if (\u26032.isEmpty() || ((int[])\u26032.get(0)).length == 0) {
                throw new JsonParseException("Expected to find data in chars, found none.");
            }
            return new Factory(new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "file")), n, \u2603, \u26032);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @Nullable
        public IGlyphProvider func_211246_a(IResourceManager iResourceManager) {
            try (IResource iResource = iResourceManager.func_199002_a(this.field_211252_a);){
                NativeImage nativeImage = NativeImage.func_211679_a(NativeImage.PixelFormat.RGBA, iResource.func_199027_b());
                int \u26032 = nativeImage.func_195702_a();
                int \u26033 = nativeImage.func_195714_b();
                int \u26034 = \u26032 / this.field_211634_b.get(0).length;
                int \u26035 = \u26033 / this.field_211634_b.size();
                float \u26036 = (float)this.field_211635_c / (float)\u26035;
                Int2ObjectOpenHashMap \u26037 = new Int2ObjectOpenHashMap();
                int i = 0;
                while (true) {
                    int n;
                    int[] nArray;
                    int n2;
                    if (i < this.field_211634_b.size()) {
                        n2 = 0;
                        nArray = this.field_211634_b.get(i);
                        n = nArray.length;
                    } else {
                        TextureGlyphProvider textureGlyphProvider = new TextureGlyphProvider(nativeImage, (Int2ObjectMap)\u26037);
                        return textureGlyphProvider;
                    }
                    for (int j = 0; j < n; ++j) {
                        GlyphInfo glyphInfo;
                        int n22 = nArray[j];
                        int n3 = n2++;
                        if (n22 == 0 || n22 == 32 || (glyphInfo = (GlyphInfo)\u26037.put(n22, (Object)new GlyphInfo(\u26036, nativeImage, n3 * \u26034, i * \u26035, \u26034, \u26035, (int)(0.5 + (double)((float)(\u2603 = this.func_211632_a(nativeImage, \u26034, \u26035, n3, i)) * \u26036)) + 1, this.field_211636_d))) == null) continue;
                        field_211609_a.warn("Codepoint '{}' declared multiple times in {}", (Object)Integer.toHexString(n22), (Object)this.field_211252_a);
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }

        private int func_211632_a(NativeImage nativeImage, int n, int n2, int n3, int n4) {
            for (\u2603 = n - 1; \u2603 >= 0; --\u2603) {
                \u2603 = n3 * n + \u2603;
                for (\u2603 = 0; \u2603 < n2; ++\u2603) {
                    \u2603 = n4 * n2 + \u2603;
                    if (nativeImage.func_211675_e(\u2603, \u2603) == 0) continue;
                    return \u2603 + 1;
                }
            }
            return \u2603 + 1;
        }
    }
}

