/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FireBlock
extends AbstractFireBlock {
    public static final IntegerProperty field_176543_a = BlockStateProperties.field_208171_X;
    public static final BooleanProperty field_176545_N = SixWayBlock.field_196488_a;
    public static final BooleanProperty field_176546_O = SixWayBlock.field_196490_b;
    public static final BooleanProperty field_176541_P = SixWayBlock.field_196492_c;
    public static final BooleanProperty field_176539_Q = SixWayBlock.field_196495_y;
    public static final BooleanProperty field_176542_R = SixWayBlock.field_196496_z;
    private static final Map<Direction, BooleanProperty> field_196449_B = SixWayBlock.field_196491_B.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN).collect(Util.func_199749_a());
    private static final VoxelShape field_242667_i = Block.func_208617_a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape field_242668_j = Block.func_208617_a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape field_242669_k = Block.func_208617_a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape field_242670_o = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape field_242671_p = Block.func_208617_a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<BlockState, VoxelShape> field_242672_q;
    private final Object2IntMap<Block> field_149849_a = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> field_149848_b = new Object2IntOpenHashMap();

    public FireBlock(AbstractBlock.Properties properties) {
        super(properties, 1.0f);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176543_a, 0)).func_206870_a(field_176545_N, false)).func_206870_a(field_176546_O, false)).func_206870_a(field_176541_P, false)).func_206870_a(field_176539_Q, false)).func_206870_a(field_176542_R, false));
        this.field_242672_q = ImmutableMap.copyOf(this.field_176227_L.func_177619_a().stream().filter(blockState -> blockState.func_177229_b(field_176543_a) == 0).collect(Collectors.toMap(Function.identity(), FireBlock::func_242673_h)));
    }

    private static VoxelShape func_242673_h(BlockState blockState) {
        VoxelShape voxelShape = VoxelShapes.func_197880_a();
        if (blockState.func_177229_b(field_176542_R).booleanValue()) {
            voxelShape = field_242667_i;
        }
        if (blockState.func_177229_b(field_176545_N).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_242670_o);
        }
        if (blockState.func_177229_b(field_176541_P).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_242671_p);
        }
        if (blockState.func_177229_b(field_176546_O).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_242669_k);
        }
        if (blockState.func_177229_b(field_176539_Q).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_242668_j);
        }
        return voxelShape.func_197766_b() ? field_235320_b_ : voxelShape;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (this.func_196260_a(blockState, iWorld, blockPos)) {
            return this.func_235494_a_(iWorld, blockPos, blockState.func_177229_b(field_176543_a));
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.field_242672_q.get(blockState.func_206870_a(field_176543_a, 0));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return this.func_196448_a(blockItemUseContext.func_195991_k(), blockItemUseContext.func_195995_a());
    }

    protected BlockState func_196448_a(IBlockReader iBlockReader, BlockPos blockPos) {
        BlockState \u26032;
        \u2603 = blockPos.func_177977_b();
        BlockState blockState = iBlockReader.func_180495_p(\u2603);
        if (this.func_196446_i(blockState) || blockState.func_224755_d(iBlockReader, \u2603, Direction.UP)) {
            return this.func_176223_P();
        }
        \u26032 = this.func_176223_P();
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanProperty = field_196449_B.get(direction);
            if (booleanProperty == null) continue;
            \u26032 = (BlockState)\u26032.func_206870_a(booleanProperty, this.func_196446_i(iBlockReader.func_180495_p(blockPos.func_177972_a(direction))));
        }
        return \u26032;
    }

    @Override
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177977_b();
        return iWorldReader.func_180495_p(\u2603).func_224755_d(iWorldReader, \u2603, Direction.UP) || this.func_196447_a(iWorldReader, blockPos);
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random2) {
        boolean bl;
        serverWorld.func_205220_G_().func_205360_a(blockPos, this, FireBlock.func_235495_a_(serverWorld.field_73012_v));
        if (!serverWorld.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            return;
        }
        if (!blockState.func_196955_c(serverWorld, blockPos)) {
            serverWorld.func_217377_a(blockPos, false);
        }
        BlockState blockState2 = serverWorld.func_180495_p(blockPos.func_177977_b());
        boolean \u26032 = blockState2.func_235714_a_(serverWorld.func_230315_m_().func_241515_q_());
        int \u26033 = blockState.func_177229_b(field_176543_a);
        if (!\u26032 && serverWorld.func_72896_J() && this.func_176537_d(serverWorld, blockPos) && random2.nextFloat() < 0.2f + (float)\u26033 * 0.03f) {
            serverWorld.func_217377_a(blockPos, false);
            return;
        }
        int \u26034 = Math.min(15, \u26033 + random2.nextInt(3) / 2);
        if (\u26033 != \u26034) {
            blockState = (BlockState)blockState.func_206870_a(field_176543_a, \u26034);
            serverWorld.func_180501_a(blockPos, blockState, 4);
        }
        if (!\u26032) {
            Random random2;
            if (!this.func_196447_a(serverWorld, blockPos)) {
                BlockPos blockPos2 = blockPos.func_177977_b();
                if (!serverWorld.func_180495_p(blockPos2).func_224755_d(serverWorld, blockPos2, Direction.UP) || \u26033 > 3) {
                    serverWorld.func_217377_a(blockPos, false);
                }
                return;
            }
            if (\u26033 == 15 && random2.nextInt(4) == 0 && !this.func_196446_i(serverWorld.func_180495_p(blockPos.func_177977_b()))) {
                serverWorld.func_217377_a(blockPos, false);
                return;
            }
        }
        int \u26035 = (bl = serverWorld.func_180502_D(blockPos)) ? -50 : 0;
        this.func_176536_a(serverWorld, blockPos.func_177974_f(), 300 + \u26035, random2, \u26033);
        this.func_176536_a(serverWorld, blockPos.func_177976_e(), 300 + \u26035, random2, \u26033);
        this.func_176536_a(serverWorld, blockPos.func_177977_b(), 250 + \u26035, random2, \u26033);
        this.func_176536_a(serverWorld, blockPos.func_177984_a(), 250 + \u26035, random2, \u26033);
        this.func_176536_a(serverWorld, blockPos.func_177978_c(), 300 + \u26035, random2, \u26033);
        this.func_176536_a(serverWorld, blockPos.func_177968_d(), 300 + \u26035, random2, \u26033);
        BlockPos.Mutable \u26036 = new BlockPos.Mutable();
        for (int i = -1; i <= 1; ++i) {
            for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                for (\u2603 = -1; \u2603 <= 4; ++\u2603) {
                    if (i == 0 && \u2603 == 0 && \u2603 == 0) continue;
                    \u2603 = 100;
                    if (\u2603 > 1) {
                        \u2603 += (\u2603 - 1) * 100;
                    }
                    \u26036.func_239621_a_(blockPos, i, \u2603, \u2603);
                    \u2603 = this.func_176538_m(serverWorld, \u26036);
                    if (\u2603 <= 0) continue;
                    \u2603 = (\u2603 + 40 + serverWorld.func_175659_aa().func_151525_a() * 7) / (\u26033 + 30);
                    if (bl) {
                        \u2603 /= 2;
                    }
                    if (\u2603 <= 0 || random2.nextInt(\u2603) > \u2603 || serverWorld.func_72896_J() && this.func_176537_d(serverWorld, \u26036)) continue;
                    \u2603 = Math.min(15, \u26033 + random2.nextInt(5) / 4);
                    serverWorld.func_180501_a(\u26036, this.func_235494_a_(serverWorld, \u26036, \u2603), 3);
                }
            }
        }
    }

    protected boolean func_176537_d(World world, BlockPos blockPos) {
        return world.func_175727_C(blockPos) || world.func_175727_C(blockPos.func_177976_e()) || world.func_175727_C(blockPos.func_177974_f()) || world.func_175727_C(blockPos.func_177978_c()) || world.func_175727_C(blockPos.func_177968_d());
    }

    private int func_220274_q(BlockState blockState) {
        if (blockState.func_235901_b_(BlockStateProperties.field_208198_y) && blockState.func_177229_b(BlockStateProperties.field_208198_y).booleanValue()) {
            return 0;
        }
        return this.field_149848_b.getInt((Object)blockState.func_177230_c());
    }

    private int func_220275_r(BlockState blockState) {
        if (blockState.func_235901_b_(BlockStateProperties.field_208198_y) && blockState.func_177229_b(BlockStateProperties.field_208198_y).booleanValue()) {
            return 0;
        }
        return this.field_149849_a.getInt((Object)blockState.func_177230_c());
    }

    private void func_176536_a(World world2, BlockPos blockPos, int n, Random random, int n2) {
        \u2603 = this.func_220274_q(world2.func_180495_p(blockPos));
        if (random.nextInt(n) < \u2603) {
            BlockState blockState = world2.func_180495_p(blockPos);
            if (random.nextInt(n2 + 10) < 5 && !world2.func_175727_C(blockPos)) {
                int n3 = Math.min(n2 + random.nextInt(5) / 4, 15);
                world2.func_180501_a(blockPos, this.func_235494_a_(world2, blockPos, n3), 3);
            } else {
                World world2;
                world2.func_217377_a(blockPos, false);
            }
            Block \u26032 = blockState.func_177230_c();
            if (\u26032 instanceof TNTBlock) {
                TNTBlock cfr_ignored_0 = (TNTBlock)\u26032;
                TNTBlock.func_196534_a(world2, blockPos);
            }
        }
    }

    private BlockState func_235494_a_(IWorld iWorld, BlockPos blockPos, int n) {
        BlockState blockState = FireBlock.func_235326_a_(iWorld, blockPos);
        if (blockState.func_203425_a(Blocks.field_150480_ab)) {
            return (BlockState)blockState.func_206870_a(field_176543_a, n);
        }
        return blockState;
    }

    private boolean func_196447_a(IBlockReader iBlockReader, BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            if (!this.func_196446_i(iBlockReader.func_180495_p(blockPos.func_177972_a(direction)))) continue;
            return true;
        }
        return false;
    }

    private int func_176538_m(IWorldReader iWorldReader, BlockPos blockPos) {
        if (!iWorldReader.func_175623_d(blockPos)) {
            return 0;
        }
        int \u26032 = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockState = iWorldReader.func_180495_p(blockPos.func_177972_a(direction));
            \u26032 = Math.max(this.func_220275_r(blockState), \u26032);
        }
        return \u26032;
    }

    @Override
    protected boolean func_196446_i(BlockState blockState) {
        return this.func_220275_r(blockState) > 0;
    }

    @Override
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.func_220082_b(blockState, world, blockPos, blockState2, bl);
        world.func_205220_G_().func_205360_a(blockPos, this, FireBlock.func_235495_a_(world.field_73012_v));
    }

    private static int func_235495_a_(Random random) {
        return 30 + random.nextInt(10);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176543_a, field_176545_N, field_176546_O, field_176541_P, field_176539_Q, field_176542_R);
    }

    private void func_180686_a(Block block, int n, int n2) {
        this.field_149849_a.put((Object)block, n);
        this.field_149848_b.put((Object)block, n2);
    }

    public static void func_149843_e() {
        FireBlock fireBlock = (FireBlock)Blocks.field_150480_ab;
        fireBlock.func_180686_a(Blocks.field_196662_n, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196664_o, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196666_p, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196668_q, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196670_r, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196672_s, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196622_bq, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196624_br, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196627_bs, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196630_bt, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196632_bu, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196635_bv, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180390_bo, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180391_bp, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180392_bq, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180386_br, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180385_bs, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180387_bt, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180407_aO, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180408_aP, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180404_aQ, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180403_aR, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180406_aS, 5, 20);
        fireBlock.func_180686_a(Blocks.field_180405_aT, 5, 20);
        fireBlock.func_180686_a(Blocks.field_150476_ad, 5, 20);
        fireBlock.func_180686_a(Blocks.field_150487_bG, 5, 20);
        fireBlock.func_180686_a(Blocks.field_150485_bF, 5, 20);
        fireBlock.func_180686_a(Blocks.field_150481_bH, 5, 20);
        fireBlock.func_180686_a(Blocks.field_150400_ck, 5, 20);
        fireBlock.func_180686_a(Blocks.field_150401_cl, 5, 20);
        fireBlock.func_180686_a(Blocks.field_196617_K, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196618_L, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196619_M, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196620_N, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196621_O, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196623_P, 5, 5);
        fireBlock.func_180686_a(Blocks.field_203204_R, 5, 5);
        fireBlock.func_180686_a(Blocks.field_203205_S, 5, 5);
        fireBlock.func_180686_a(Blocks.field_203206_T, 5, 5);
        fireBlock.func_180686_a(Blocks.field_203207_U, 5, 5);
        fireBlock.func_180686_a(Blocks.field_203208_V, 5, 5);
        fireBlock.func_180686_a(Blocks.field_203209_W, 5, 5);
        fireBlock.func_180686_a(Blocks.field_209389_ab, 5, 5);
        fireBlock.func_180686_a(Blocks.field_209390_ac, 5, 5);
        fireBlock.func_180686_a(Blocks.field_209391_ad, 5, 5);
        fireBlock.func_180686_a(Blocks.field_209392_ae, 5, 5);
        fireBlock.func_180686_a(Blocks.field_209393_af, 5, 5);
        fireBlock.func_180686_a(Blocks.field_209394_ag, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196626_Q, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196629_R, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196631_S, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196634_T, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196637_U, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196639_V, 5, 5);
        fireBlock.func_180686_a(Blocks.field_196642_W, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196645_X, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196647_Y, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196648_Z, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196572_aa, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196574_ab, 30, 60);
        fireBlock.func_180686_a(Blocks.field_150342_X, 30, 20);
        fireBlock.func_180686_a(Blocks.field_150335_W, 15, 100);
        fireBlock.func_180686_a(Blocks.field_150349_c, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196554_aH, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196555_aI, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196800_gd, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196801_ge, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196802_gf, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196803_gg, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196804_gh, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196805_gi, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196605_bc, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196606_bd, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196607_be, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196609_bf, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196610_bg, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196612_bh, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196613_bi, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196614_bj, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196615_bk, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196616_bl, 60, 100);
        fireBlock.func_180686_a(Blocks.field_222387_by, 60, 100);
        fireBlock.func_180686_a(Blocks.field_222383_bA, 60, 100);
        fireBlock.func_180686_a(Blocks.field_222388_bz, 60, 100);
        fireBlock.func_180686_a(Blocks.field_196556_aL, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196557_aM, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196558_aN, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196559_aO, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196560_aP, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196561_aQ, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196562_aR, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196563_aS, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196564_aT, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196565_aU, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196566_aV, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196567_aW, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196568_aX, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196569_aY, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196570_aZ, 30, 60);
        fireBlock.func_180686_a(Blocks.field_196602_ba, 30, 60);
        fireBlock.func_180686_a(Blocks.field_150395_bd, 15, 100);
        fireBlock.func_180686_a(Blocks.field_150402_ci, 5, 5);
        fireBlock.func_180686_a(Blocks.field_150407_cf, 60, 20);
        fireBlock.func_180686_a(Blocks.field_235396_nb_, 15, 20);
        fireBlock.func_180686_a(Blocks.field_196724_fH, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196725_fI, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196727_fJ, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196729_fK, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196731_fL, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196733_fM, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196735_fN, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196737_fO, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196739_fP, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196741_fQ, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196743_fR, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196745_fS, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196747_fT, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196749_fU, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196751_fV, 60, 20);
        fireBlock.func_180686_a(Blocks.field_196753_fW, 60, 20);
        fireBlock.func_180686_a(Blocks.field_203216_jz, 30, 60);
        fireBlock.func_180686_a(Blocks.field_222405_kQ, 60, 60);
        fireBlock.func_180686_a(Blocks.field_222420_lI, 60, 60);
        fireBlock.func_180686_a(Blocks.field_222428_lQ, 30, 20);
        fireBlock.func_180686_a(Blocks.field_222436_lZ, 5, 20);
        fireBlock.func_180686_a(Blocks.field_222434_lW, 60, 100);
        fireBlock.func_180686_a(Blocks.field_226906_mb_, 5, 20);
        fireBlock.func_180686_a(Blocks.field_226905_ma_, 30, 20);
    }
}

