/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.dto.WorldTemplatePaginatedList;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.NotifableRealmsScreen;
import com.mojang.realmsclient.util.RealmsTextureManager;
import com.mojang.realmsclient.util.TextRenderingUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.realms.RealmsNarratorHelper;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsSelectWorldTemplateScreen
extends RealmsScreen {
    private static final Logger field_224515_a = LogManager.getLogger();
    private static final ResourceLocation field_237987_b_ = new ResourceLocation("realms", "textures/gui/realms/link_icons.png");
    private static final ResourceLocation field_237988_c_ = new ResourceLocation("realms", "textures/gui/realms/trailer_icons.png");
    private static final ResourceLocation field_237989_p_ = new ResourceLocation("realms", "textures/gui/realms/slot_frame.png");
    private static final ITextComponent field_243163_q = new TranslationTextComponent("mco.template.info.tooltip");
    private static final ITextComponent field_243164_r = new TranslationTextComponent("mco.template.trailer.tooltip");
    private final NotifableRealmsScreen field_224516_b;
    private WorldTemplateSelectionList field_224517_c;
    private int field_224518_d = -1;
    private ITextComponent field_224519_e;
    private Button field_224520_f;
    private Button field_224521_g;
    private Button field_224522_h;
    @Nullable
    private ITextComponent field_224523_i;
    private String field_224524_j;
    private final RealmsServer.ServerType field_224525_k;
    private int field_224526_l;
    @Nullable
    private ITextComponent[] field_224527_m;
    private String field_224528_n;
    private boolean field_224529_o;
    private boolean field_224530_p;
    @Nullable
    private List<TextRenderingUtils.Line> field_224531_q;

    public RealmsSelectWorldTemplateScreen(NotifableRealmsScreen notifableRealmsScreen, RealmsServer.ServerType serverType) {
        this(notifableRealmsScreen, serverType, null);
    }

    public RealmsSelectWorldTemplateScreen(NotifableRealmsScreen notifableRealmsScreen, RealmsServer.ServerType serverType, @Nullable WorldTemplatePaginatedList worldTemplatePaginatedList) {
        this.field_224516_b = notifableRealmsScreen;
        this.field_224525_k = serverType;
        if (worldTemplatePaginatedList == null) {
            this.field_224517_c = new WorldTemplateSelectionList();
            this.func_224497_a(new WorldTemplatePaginatedList(10));
        } else {
            this.field_224517_c = new WorldTemplateSelectionList(Lists.newArrayList(worldTemplatePaginatedList.field_230657_a_));
            this.func_224497_a(worldTemplatePaginatedList);
        }
        this.field_224519_e = new TranslationTextComponent("mco.template.title");
    }

    public void func_238001_a_(ITextComponent iTextComponent) {
        this.field_224519_e = iTextComponent;
    }

    public void func_238002_a_(ITextComponent ... iTextComponentArray) {
        this.field_224527_m = iTextComponentArray;
        this.field_224529_o = true;
    }

    @Override
    public boolean func_231044_a_(double d, double d2, int n) {
        if (this.field_224530_p && this.field_224528_n != null) {
            Util.func_110647_a().func_195640_a("https://www.minecraft.net/realms/adventure-maps-in-1-9");
            return true;
        }
        return super.func_231044_a_(d, d2, n);
    }

    @Override
    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_224517_c = new WorldTemplateSelectionList(this.field_224517_c.func_223879_b());
        this.field_224521_g = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 206, this.field_230709_l_ - 32, 100, 20, new TranslationTextComponent("mco.template.button.trailer"), button -> this.func_224496_i()));
        this.field_224520_f = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 32, 100, 20, new TranslationTextComponent("mco.template.button.select"), button -> this.func_224500_h()));
        ITextComponent iTextComponent = this.field_224525_k == RealmsServer.ServerType.MINIGAME ? DialogTexts.field_240633_d_ : DialogTexts.field_240637_h_;
        Button \u26032 = new Button(this.field_230708_k_ / 2 + 6, this.field_230709_l_ - 32, 100, 20, iTextComponent, button -> this.func_224484_g());
        this.func_230480_a_(\u26032);
        this.field_224522_h = this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 112, this.field_230709_l_ - 32, 100, 20, new TranslationTextComponent("mco.template.button.publisher"), button -> this.func_224511_j()));
        this.field_224520_f.field_230693_o_ = false;
        this.field_224521_g.field_230694_p_ = false;
        this.field_224522_h.field_230694_p_ = false;
        this.func_230481_d_(this.field_224517_c);
        this.func_212932_b(this.field_224517_c);
        Stream<ITextComponent> \u26033 = Stream.of(this.field_224519_e);
        if (this.field_224527_m != null) {
            \u26033 = Stream.concat(Stream.of(this.field_224527_m), \u26033);
        }
        RealmsNarratorHelper.func_239549_a_(\u26033.filter(Objects::nonNull).map(ITextComponent::getString).collect(Collectors.toList()));
    }

    private void func_224514_b() {
        this.field_224522_h.field_230694_p_ = this.func_224510_d();
        this.field_224521_g.field_230694_p_ = this.func_224512_f();
        this.field_224520_f.field_230693_o_ = this.func_224495_c();
    }

    private boolean func_224495_c() {
        return this.field_224518_d != -1;
    }

    private boolean func_224510_d() {
        return this.field_224518_d != -1 && !this.func_224487_e().field_230651_e_.isEmpty();
    }

    private WorldTemplate func_224487_e() {
        return this.field_224517_c.func_223877_a(this.field_224518_d);
    }

    private boolean func_224512_f() {
        return this.field_224518_d != -1 && !this.func_224487_e().field_230653_g_.isEmpty();
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        --this.field_224526_l;
        if (this.field_224526_l < 0) {
            this.field_224526_l = 0;
        }
    }

    @Override
    public boolean func_231046_a_(int n, int n2, int n3) {
        if (n == 256) {
            this.func_224484_g();
            return true;
        }
        return super.func_231046_a_(n, n2, n3);
    }

    private void func_224484_g() {
        this.field_224516_b.func_223627_a_(null);
        this.field_230706_i_.func_147108_a(this.field_224516_b);
    }

    private void func_224500_h() {
        if (this.func_238024_y_()) {
            this.field_224516_b.func_223627_a_(this.func_224487_e());
        }
    }

    private boolean func_238024_y_() {
        return this.field_224518_d >= 0 && this.field_224518_d < this.field_224517_c.func_230965_k_();
    }

    private void func_224496_i() {
        if (this.func_238024_y_()) {
            WorldTemplate worldTemplate = this.func_224487_e();
            if (!"".equals(worldTemplate.field_230653_g_)) {
                Util.func_110647_a().func_195640_a(worldTemplate.field_230653_g_);
            }
        }
    }

    private void func_224511_j() {
        if (this.func_238024_y_()) {
            WorldTemplate worldTemplate = this.func_224487_e();
            if (!"".equals(worldTemplate.field_230651_e_)) {
                Util.func_110647_a().func_195640_a(worldTemplate.field_230651_e_);
            }
        }
    }

    private void func_224497_a(final WorldTemplatePaginatedList worldTemplatePaginatedList) {
        new Thread("realms-template-fetcher"){

            @Override
            public void run() {
                WorldTemplatePaginatedList \u26033 = worldTemplatePaginatedList;
                RealmsClient \u26032 = RealmsClient.func_224911_a();
                while (\u26033 != null) {
                    Either either = RealmsSelectWorldTemplateScreen.this.func_224509_a(\u26033, \u26032);
                    \u26033 = RealmsSelectWorldTemplateScreen.this.field_230706_i_.func_213169_a(() -> {
                        if (either.right().isPresent()) {
                            field_224515_a.error("Couldn't fetch templates: {}", either.right().get());
                            if (RealmsSelectWorldTemplateScreen.this.field_224517_c.func_223878_a()) {
                                RealmsSelectWorldTemplateScreen.this.field_224531_q = TextRenderingUtils.func_225224_a(I18n.func_135052_a("mco.template.select.failure", new Object[0]), new TextRenderingUtils.LineSegment[0]);
                            }
                            return null;
                        }
                        WorldTemplatePaginatedList worldTemplatePaginatedList2 = (WorldTemplatePaginatedList)either.left().get();
                        for (WorldTemplate worldTemplate : worldTemplatePaginatedList2.field_230657_a_) {
                            RealmsSelectWorldTemplateScreen.this.field_224517_c.func_223876_a(worldTemplate);
                        }
                        if (worldTemplatePaginatedList2.field_230657_a_.isEmpty()) {
                            if (RealmsSelectWorldTemplateScreen.this.field_224517_c.func_223878_a()) {
                                String string = I18n.func_135052_a("mco.template.select.none", "%link");
                                TextRenderingUtils.LineSegment lineSegment = TextRenderingUtils.LineSegment.func_225214_a(I18n.func_135052_a("mco.template.select.none.linkTitle", new Object[0]), "https://aka.ms/MinecraftRealmsContentCreator");
                                RealmsSelectWorldTemplateScreen.this.field_224531_q = TextRenderingUtils.func_225224_a(string, lineSegment);
                            }
                            return null;
                        }
                        return worldTemplatePaginatedList2;
                    }).join();
                }
            }
        }.start();
    }

    private Either<WorldTemplatePaginatedList, String> func_224509_a(WorldTemplatePaginatedList worldTemplatePaginatedList, RealmsClient realmsClient) {
        try {
            return Either.left((Object)realmsClient.func_224930_a(worldTemplatePaginatedList.field_230658_b_ + 1, worldTemplatePaginatedList.field_230659_c_, this.field_224525_k));
        }
        catch (RealmsServiceException realmsServiceException) {
            return Either.right((Object)realmsServiceException.getMessage());
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.field_224523_i = null;
        this.field_224524_j = null;
        this.field_224530_p = false;
        this.func_230446_a_(matrixStack);
        this.field_224517_c.func_230430_a_(matrixStack, n, n2, f);
        if (this.field_224531_q != null) {
            this.func_237992_a_(matrixStack, n, n2, this.field_224531_q);
        }
        RealmsSelectWorldTemplateScreen.func_238472_a_(matrixStack, this.field_230712_o_, this.field_224519_e, this.field_230708_k_ / 2, 13, 0xFFFFFF);
        if (this.field_224529_o) {
            int n3;
            ITextComponent[] iTextComponentArray = this.field_224527_m;
            for (n3 = 0; n3 < iTextComponentArray.length; ++n3) {
                \u2603 = this.field_230712_o_.func_238414_a_(iTextComponentArray[n3]);
                \u26032 = this.field_230708_k_ / 2 - \u2603 / 2;
                \u2603 = RealmsSelectWorldTemplateScreen.func_239562_k_(-1 + n3);
                if (n < \u26032 || n > \u26032 + \u2603 || n2 < \u2603 || n2 > \u2603 + this.field_230712_o_.field_78288_b) continue;
                this.field_224530_p = true;
            }
            for (n3 = 0; n3 < iTextComponentArray.length; ++n3) {
                ITextComponent iTextComponent = iTextComponentArray[n3];
                int \u26032 = 0xA0A0A0;
                if (this.field_224528_n != null) {
                    if (this.field_224530_p) {
                        \u26032 = 7107012;
                        iTextComponent = iTextComponent.func_230532_e_().func_240699_a_(TextFormatting.STRIKETHROUGH);
                    } else {
                        \u26032 = 0x3366BB;
                    }
                }
                RealmsSelectWorldTemplateScreen.func_238472_a_(matrixStack, this.field_230712_o_, iTextComponent, this.field_230708_k_ / 2, RealmsSelectWorldTemplateScreen.func_239562_k_(-1 + n3), \u26032);
            }
        }
        super.func_230430_a_(matrixStack, n, n2, f);
        this.func_237993_a_(matrixStack, this.field_224523_i, n, n2);
    }

    private void func_237992_a_(MatrixStack matrixStack, int n, int n2, List<TextRenderingUtils.Line> list) {
        for (int i = 0; i < list.size(); ++i) {
            TextRenderingUtils.Line line = list.get(i);
            int \u26032 = RealmsSelectWorldTemplateScreen.func_239562_k_(4 + i);
            int \u26033 = line.field_225213_a.stream().mapToInt(lineSegment -> this.field_230712_o_.func_78256_a(lineSegment.func_225215_a())).sum();
            int \u26034 = this.field_230708_k_ / 2 - \u26033 / 2;
            for (TextRenderingUtils.LineSegment lineSegment2 : line.field_225213_a) {
                int n3 = lineSegment2.func_225217_b() ? 0x3366BB : 0xFFFFFF;
                \u2603 = this.field_230712_o_.func_238405_a_(matrixStack, lineSegment2.func_225215_a(), \u26034, \u26032, n3);
                if (lineSegment2.func_225217_b() && n > \u26034 && n < \u2603 && n2 > \u26032 - 3 && n2 < \u26032 + 8) {
                    this.field_224523_i = new StringTextComponent(lineSegment2.func_225216_c());
                    this.field_224524_j = lineSegment2.func_225216_c();
                }
                \u26034 = \u2603;
            }
        }
    }

    protected void func_237993_a_(MatrixStack matrixStack, @Nullable ITextComponent iTextComponent, int n, int n2) {
        if (iTextComponent == null) {
            return;
        }
        \u2603 = n + 12;
        \u2603 = n2 - 12;
        \u2603 = this.field_230712_o_.func_238414_a_(iTextComponent);
        this.func_238468_a_(matrixStack, \u2603 - 3, \u2603 - 3, \u2603 + \u2603 + 3, \u2603 + 8 + 3, -1073741824, -1073741824);
        this.field_230712_o_.func_243246_a(matrixStack, iTextComponent, \u2603, \u2603, 0xFFFFFF);
    }

    class WorldTemplateSelectionEntry
    extends ExtendedList.AbstractListEntry<WorldTemplateSelectionEntry> {
        private final WorldTemplate field_223756_a;

        public WorldTemplateSelectionEntry(WorldTemplate worldTemplate) {
            this.field_223756_a = worldTemplate;
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_238029_a_(matrixStack, this.field_223756_a, n3, n2, n6, n7);
        }

        private void func_238029_a_(MatrixStack matrixStack, WorldTemplate worldTemplate, int n, int n2, int n3, int n4) {
            \u2603 = n + 45 + 20;
            RealmsSelectWorldTemplateScreen.this.field_230712_o_.func_238421_b_(matrixStack, worldTemplate.field_230648_b_, \u2603, n2 + 2, 0xFFFFFF);
            RealmsSelectWorldTemplateScreen.this.field_230712_o_.func_238421_b_(matrixStack, worldTemplate.field_230650_d_, \u2603, n2 + 15, 0x6C6C6C);
            RealmsSelectWorldTemplateScreen.this.field_230712_o_.func_238421_b_(matrixStack, worldTemplate.field_230649_c_, \u2603 + 227 - RealmsSelectWorldTemplateScreen.this.field_230712_o_.func_78256_a(worldTemplate.field_230649_c_), n2 + 1, 0x6C6C6C);
            if (!("".equals(worldTemplate.field_230651_e_) && "".equals(worldTemplate.field_230653_g_) && "".equals(worldTemplate.field_230654_h_))) {
                this.func_238028_a_(matrixStack, \u2603 - 1, n2 + 25, n3, n4, worldTemplate.field_230651_e_, worldTemplate.field_230653_g_, worldTemplate.field_230654_h_);
            }
            this.func_238027_a_(matrixStack, n, n2 + 1, n3, n4, worldTemplate);
        }

        private void func_238027_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, WorldTemplate worldTemplate) {
            RealmsTextureManager.func_225202_a(worldTemplate.field_230647_a_, worldTemplate.field_230652_f_);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            AbstractGui.func_238463_a_(matrixStack, n + 1, n2 + 1, 0.0f, 0.0f, 38, 38, 38, 38);
            RealmsSelectWorldTemplateScreen.this.field_230706_i_.func_110434_K().func_110577_a(field_237989_p_);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            AbstractGui.func_238463_a_(matrixStack, n, n2, 0.0f, 0.0f, 40, 40, 40, 40);
        }

        private void func_238028_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, String string, String string22, String string3) {
            String string22;
            if (!"".equals(string3)) {
                RealmsSelectWorldTemplateScreen.this.field_230712_o_.func_238421_b_(matrixStack, string3, n, n2 + 4, 0x4C4C4C);
            }
            int n5 = "".equals(string3) ? 0 : RealmsSelectWorldTemplateScreen.this.field_230712_o_.func_78256_a(string3) + 2;
            boolean \u26032 = false;
            boolean \u26033 = false;
            boolean \u26034 = "".equals(string);
            if (n3 >= n + n5 && n3 <= n + n5 + 32 && n4 >= n2 && n4 <= n2 + 15 && n4 < RealmsSelectWorldTemplateScreen.this.field_230709_l_ - 15 && n4 > 32) {
                if (n3 <= n + 15 + n5 && n3 > n5) {
                    if (\u26034) {
                        \u26033 = true;
                    } else {
                        \u26032 = true;
                    }
                } else if (!\u26034) {
                    \u26033 = true;
                }
            }
            if (!\u26034) {
                RealmsSelectWorldTemplateScreen.this.field_230706_i_.func_110434_K().func_110577_a(field_237987_b_);
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.pushMatrix();
                RenderSystem.scalef(1.0f, 1.0f, 1.0f);
                float f = \u26032 ? 15.0f : 0.0f;
                AbstractGui.func_238463_a_(matrixStack, n + n5, n2, f, 0.0f, 15, 15, 30, 15);
                RenderSystem.popMatrix();
            }
            if (!"".equals(string22)) {
                RealmsSelectWorldTemplateScreen.this.field_230706_i_.func_110434_K().func_110577_a(field_237988_c_);
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.pushMatrix();
                RenderSystem.scalef(1.0f, 1.0f, 1.0f);
                int n6 = n + n5 + (\u26034 ? 0 : 17);
                float \u26035 = \u26033 ? 15.0f : 0.0f;
                AbstractGui.func_238463_a_(matrixStack, n6, n2, \u26035, 0.0f, 15, 15, 30, 15);
                RenderSystem.popMatrix();
            }
            if (\u26032) {
                RealmsSelectWorldTemplateScreen.this.field_224523_i = field_243163_q;
                RealmsSelectWorldTemplateScreen.this.field_224524_j = string;
            } else if (\u26033 && !"".equals(string22)) {
                RealmsSelectWorldTemplateScreen.this.field_224523_i = field_243164_r;
                RealmsSelectWorldTemplateScreen.this.field_224524_j = string22;
            }
        }
    }

    class WorldTemplateSelectionList
    extends RealmsObjectSelectionList<WorldTemplateSelectionEntry> {
        public WorldTemplateSelectionList() {
            this(Collections.emptyList());
        }

        public WorldTemplateSelectionList(Iterable<WorldTemplate> iterable) {
            super(RealmsSelectWorldTemplateScreen.this.field_230708_k_, RealmsSelectWorldTemplateScreen.this.field_230709_l_, RealmsSelectWorldTemplateScreen.this.field_224529_o ? RealmsSelectWorldTemplateScreen.func_239562_k_(1) : 32, RealmsSelectWorldTemplateScreen.this.field_230709_l_ - 40, 46);
            iterable.forEach(this::func_223876_a);
        }

        public void func_223876_a(WorldTemplate worldTemplate) {
            this.func_230513_b_(new WorldTemplateSelectionEntry(worldTemplate));
        }

        @Override
        public boolean func_231044_a_(double d, double d2, int n) {
            if (n == 0 && d2 >= (double)this.field_230672_i_ && d2 <= (double)this.field_230673_j_) {
                \u2603 = this.field_230670_d_ / 2 - 150;
                if (RealmsSelectWorldTemplateScreen.this.field_224524_j != null) {
                    Util.func_110647_a().func_195640_a(RealmsSelectWorldTemplateScreen.this.field_224524_j);
                }
                \u2603 = (int)Math.floor(d2 - (double)this.field_230672_i_) - this.field_230677_n_ + (int)this.func_230966_l_() - 4;
                \u2603 = \u2603 / this.field_230669_c_;
                if (d >= (double)\u2603 && d < (double)this.func_230952_d_() && \u2603 >= 0 && \u2603 >= 0 && \u2603 < this.func_230965_k_()) {
                    this.func_231400_a_(\u2603);
                    this.func_231401_a_(\u2603, \u2603, d, d2, this.field_230670_d_);
                    if (\u2603 >= RealmsSelectWorldTemplateScreen.this.field_224517_c.func_230965_k_()) {
                        return super.func_231044_a_(d, d2, n);
                    }
                    RealmsSelectWorldTemplateScreen.this.field_224526_l = RealmsSelectWorldTemplateScreen.this.field_224526_l + 7;
                    if (RealmsSelectWorldTemplateScreen.this.field_224526_l >= 10) {
                        RealmsSelectWorldTemplateScreen.this.func_224500_h();
                    }
                    return true;
                }
            }
            return super.func_231044_a_(d, d2, n);
        }

        @Override
        public void func_231400_a_(int n) {
            this.func_239561_k_(n);
            if (n != -1) {
                WorldTemplate worldTemplate = RealmsSelectWorldTemplateScreen.this.field_224517_c.func_223877_a(n);
                String \u26032 = I18n.func_135052_a("narrator.select.list.position", n + 1, RealmsSelectWorldTemplateScreen.this.field_224517_c.func_230965_k_());
                String \u26033 = I18n.func_135052_a("mco.template.select.narrate.version", worldTemplate.field_230649_c_);
                String \u26034 = I18n.func_135052_a("mco.template.select.narrate.authors", worldTemplate.field_230650_d_);
                String \u26035 = RealmsNarratorHelper.func_239552_b_(Arrays.asList(worldTemplate.field_230648_b_, \u26034, worldTemplate.field_230654_h_, \u26033, \u26032));
                RealmsNarratorHelper.func_239550_a_(I18n.func_135052_a("narrator.select", \u26035));
            }
        }

        @Override
        public void func_241215_a_(@Nullable WorldTemplateSelectionEntry worldTemplateSelectionEntry) {
            super.func_241215_a_(worldTemplateSelectionEntry);
            RealmsSelectWorldTemplateScreen.this.field_224518_d = this.func_231039_at__().indexOf(worldTemplateSelectionEntry);
            RealmsSelectWorldTemplateScreen.this.func_224514_b();
        }

        @Override
        public int func_230945_b_() {
            return this.func_230965_k_() * 46;
        }

        @Override
        public int func_230949_c_() {
            return 300;
        }

        @Override
        public void func_230433_a_(MatrixStack matrixStack) {
            RealmsSelectWorldTemplateScreen.this.func_230446_a_(matrixStack);
        }

        @Override
        public boolean func_230971_aw__() {
            return RealmsSelectWorldTemplateScreen.this.func_241217_q_() == this;
        }

        public boolean func_223878_a() {
            return this.func_230965_k_() == 0;
        }

        public WorldTemplate func_223877_a(int n) {
            return ((WorldTemplateSelectionEntry)this.func_231039_at__().get(n)).field_223756_a;
        }

        public List<WorldTemplate> func_223879_b() {
            return this.func_231039_at__().stream().map(worldTemplateSelectionEntry -> ((WorldTemplateSelectionEntry)worldTemplateSelectionEntry).field_223756_a).collect(Collectors.toList());
        }
    }
}

