/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.client.MainWindow;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlDebugTextUtils;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import oshi.SystemInfo;
import oshi.hardware.Processor;

public class GLX {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String capsString = "";
    private static String cpuInfo;
    private static final Map<Integer, String> LOOKUP_MAP;

    public static String getOpenGLVersionString() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (GLFW.glfwGetCurrentContext() == 0L) {
            return "NO CONTEXT";
        }
        return GlStateManager.func_227610_C_(7937) + " GL version " + GlStateManager.func_227610_C_(7938) + ", " + GlStateManager.func_227610_C_(7936);
    }

    public static int _getRefreshRate(MainWindow mainWindow) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        long l = GLFW.glfwGetWindowMonitor((long)mainWindow.func_198092_i());
        if (l == 0L) {
            l = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode \u26032 = l == 0L ? null : GLFW.glfwGetVideoMode((long)l);
        return \u26032 == null ? 0 : \u26032.refreshRate();
    }

    public static String _getLWJGLVersion() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return Version.getVersion();
    }

    public static LongSupplier _initGlfw() {
        LongSupplier longSupplier;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        MainWindow.func_211162_a((n, string) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", n, string));
        });
        ArrayList arrayList = Lists.newArrayList();
        GLFWErrorCallback \u26032 = GLFW.glfwSetErrorCallback((n, l) -> arrayList.add(String.format("GLFW error during init: [0x%X]%s", n, l)));
        if (GLFW.glfwInit()) {
            longSupplier = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
            for (String string2 : arrayList) {
                LOGGER.error("GLFW error collected during initialization: {}", (Object)string2);
            }
        } else {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)arrayList));
        }
        RenderSystem.setErrorCallback((GLFWErrorCallbackI)\u26032);
        return longSupplier;
    }

    public static void _setGlfwErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLFWErrorCallback gLFWErrorCallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)gLFWErrorCallbackI);
        if (gLFWErrorCallback != null) {
            gLFWErrorCallback.free();
        }
    }

    public static boolean _shouldClose(MainWindow mainWindow) {
        return GLFW.glfwWindowShouldClose((long)mainWindow.func_198092_i());
    }

    public static void _setupNvFogDistance() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (GL.getCapabilities().GL_NV_fog_distance) {
            GlStateManager.func_227742_m_(34138, 34139);
        }
    }

    public static void _init(int n2, boolean bl) {
        int n2;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLCapabilities gLCapabilities = GL.getCapabilities();
        capsString = "Using framebuffer using " + GlStateManager.func_227666_a_(gLCapabilities);
        try {
            Processor[] processorArray = new SystemInfo().getHardware().getProcessors();
            cpuInfo = String.format("%dx %s", processorArray.length, processorArray[0]).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GlDebugTextUtils.func_209247_b(n2, bl);
    }

    public static String _getCapsString() {
        return capsString;
    }

    public static String _getCpuInfo() {
        return cpuInfo == null ? "<unknown>" : cpuInfo;
    }

    public static void _renderCrosshair(int n, boolean bl, boolean bl2, boolean bl3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.func_227621_I_();
        GlStateManager.func_227667_a_(false);
        Tessellator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        GL11.glLineWidth((float)4.0f);
        \u26032.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (bl) {
            \u26032.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            \u26032.func_225582_a_(n, 0.0, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        }
        if (bl2) {
            \u26032.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            \u26032.func_225582_a_(0.0, n, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        }
        if (bl3) {
            \u26032.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            \u26032.func_225582_a_(0.0, 0.0, n).func_225586_a_(0, 0, 0, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glLineWidth((float)2.0f);
        \u26032.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (bl) {
            \u26032.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(255, 0, 0, 255).func_181675_d();
            \u26032.func_225582_a_(n, 0.0, 0.0).func_225586_a_(255, 0, 0, 255).func_181675_d();
        }
        if (bl2) {
            \u26032.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(0, 255, 0, 255).func_181675_d();
            \u26032.func_225582_a_(0.0, n, 0.0).func_225586_a_(0, 255, 0, 255).func_181675_d();
        }
        if (bl3) {
            \u26032.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(127, 127, 255, 255).func_181675_d();
            \u26032.func_225582_a_(0.0, 0.0, n).func_225586_a_(127, 127, 255, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glLineWidth((float)1.0f);
        GlStateManager.func_227667_a_(true);
        GlStateManager.func_227619_H_();
    }

    public static String getErrorString(int n) {
        return LOOKUP_MAP.get(n);
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T t, Consumer<T> consumer) {
        consumer.accept(t);
        return t;
    }

    static {
        LOOKUP_MAP = GLX.make(Maps.newHashMap(), hashMap -> {
            hashMap.put(0, "No error");
            hashMap.put(1280, "Enum parameter is invalid for this function");
            hashMap.put(1281, "Parameter is invalid for this function");
            hashMap.put(1282, "Current state is invalid for this function");
            hashMap.put(1283, "Stack overflow");
            hashMap.put(1284, "Stack underflow");
            hashMap.put(1285, "Out of memory");
            hashMap.put(1286, "Operation on incomplete framebuffer");
            hashMap.put(1286, "Operation on incomplete framebuffer");
        });
    }
}

