/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Agent;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilGameProfileRepository;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilSocialInteractionsService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import java.net.Proxy;

public class YggdrasilAuthenticationService
extends HttpAuthenticationService {
    private Proxy proxy;
    private String clientToken;
    private Environment environment;

    public YggdrasilAuthenticationService(Proxy proxy) {
        super(proxy);
        this.proxy = proxy;
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken) {
        super(proxy);
        this.proxy = proxy;
        this.clientToken = clientToken;
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken, Environment environment) {
        super(proxy);
        this.proxy = proxy;
        this.clientToken = clientToken;
        this.environment = environment;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    @Override
    public UserAuthentication createUserAuthentication(Agent agent) {
        return new YggdrasilUserAuthentication(this, this.clientToken, agent);
    }

    @Override
    public MinecraftSessionService createMinecraftSessionService() {
        return new YggdrasilMinecraftSessionService(this, this.environment);
    }

    @Override
    public GameProfileRepository createProfileRepository() {
        return new YggdrasilGameProfileRepository(this, this.environment);
    }

    public YggdrasilSocialInteractionsService createSocialInteractionsService(String accessToken) throws AuthenticationException {
        return new YggdrasilSocialInteractionsService(this, accessToken, this.environment);
    }
}

