/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.launcher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.launcher.GenericGameProfile;
import com.mojang.authlib.launcher.InlineLoaderUtils;
import com.mojang.authlib.launcher.LauncherAccessor;
import com.mojang.authlib.launcher.LauncherAccessorFactory;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class LauncherUtils {
    public static String SESSION_HARDWARE_ID_PROPERTY;
    public static String SESSION_ID_PROPERTY;
    public static String SESSION_BASE_PROPERTY;
    private static final LauncherAccessor LAUNCHER_ACCESSOR;
    static Gson GSON;

    public static void error(Throwable e) {
        LAUNCHER_ACCESSOR.error(e);
    }

    public static void debug(String format, Object ... args) {
        LAUNCHER_ACCESSOR.debug(format, args);
    }

    public static CompletableFuture<GenericGameProfile> findByUsername(String username) {
        return LAUNCHER_ACCESSOR.findByUsername(username);
    }

    public static CompletableFuture<GenericGameProfile> findByUUID(UUID uuid) {
        return LAUNCHER_ACCESSOR.findByUUID(uuid);
    }

    public static CompletableFuture<Boolean> joinServerAsync(String username, String accessToken, String serverId) {
        return LAUNCHER_ACCESSOR.joinServerAsync(username, accessToken, serverId);
    }

    public static CompletableFuture<Boolean> joinServerAsync(UUID uuid, String accessToken, String serverId) {
        return LAUNCHER_ACCESSOR.joinServerAsync(uuid, accessToken, serverId);
    }

    public static CompletableFuture<GenericGameProfile> checkServerAsync(String username, String serverID, String ip) {
        return LAUNCHER_ACCESSOR.checkServerAsync(username, serverID, ip);
    }

    public static Map<String, GenericTexture> parseTexturesProperty(String value) {
        String decoded = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
        MinecraftTexturesProperty property = (MinecraftTexturesProperty)GSON.fromJson(decoded, MinecraftTexturesProperty.class);
        return property.textures;
    }

    static {
        InlineLoaderUtils.load();
        SESSION_HARDWARE_ID_PROPERTY = "session_hardware_id";
        SESSION_ID_PROPERTY = "session_id";
        SESSION_BASE_PROPERTY = "session_";
        LAUNCHER_ACCESSOR = LauncherAccessorFactory.create();
        GSON = new GsonBuilder().create();
    }

    public static class MinecraftTexturesProperty {
        public long timestamp;
        public String profileId;
        public String profileName;
        public boolean isPublic;
        public Map<String, GenericTexture> textures;

        public MinecraftTexturesProperty() {
        }

        public MinecraftTexturesProperty(long timestamp, String profileId, String profileName, boolean isPublic, Map<String, GenericTexture> textures) {
            this.timestamp = timestamp;
            this.profileId = profileId;
            this.profileName = profileName;
            this.isPublic = isPublic;
            this.textures = textures;
        }
    }

    public static class GenericTexture {
        private final String url;
        private final String hash;
        private final Map<String, String> metadata;

        public GenericTexture(String url, String hash, Map<String, String> metadata) {
            this.url = url;
            this.hash = hash;
            this.metadata = metadata;
        }

        public String getUrl() {
            return this.url;
        }

        public String getHash() {
            return this.hash;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

