/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.launcher;

import com.mojang.authlib.launcher.LauncherAccessor;
import com.mojang.authlib.launcher.LauncherDefaultAccessor;
import com.mojang.authlib.launcher.LauncherReflectionAccessor;

public class LauncherAccessorFactory {
    public static LauncherAccessor create() {
        LauncherAccessor accessor = null;
        Throwable defaultAccessorException = null;
        try {
            accessor = new LauncherDefaultAccessor();
            accessor.selfTest();
            accessor.debug("Initialized authlib with default accessor", new Object[0]);
            return accessor;
        }
        catch (Throwable e) {
            defaultAccessorException = e;
            try {
                accessor = new LauncherReflectionAccessor();
                accessor.selfTest();
                accessor.debug("Initialized authlib with reflection accessor", new Object[0]);
                return accessor;
            }
            catch (Throwable e2) {
                defaultAccessorException.printStackTrace();
                e2.printStackTrace();
                System.out.print("[CRITICAL ERROR] Authlib cloud not find launcher classes\n");
                throw new RuntimeException("[CRITICAL ERROR] Authlib cloud not find launcher classes");
            }
        }
    }
}

